# Files to Upload to cPanel - Checklist

## ✅ Required Files for Upload

Check off each item as you upload it:

### Core Application Files
- [ ] `src/` directory (entire folder with all subdirectories)
- [ ] `custom-typings/` directory
- [ ] `package.json`
- [ ] `package-lock.json`
- [ ] `tsconfig.json`

### Configuration Files
- [ ] `.env` file (created from `env-production.txt`)
  - ⚠️ **IMPORTANT**: Keep this file secure, not in public_html

### Dependencies
- [ ] `node_modules/` directory (OR install via `npm install` on server)

### Optional Documentation
- [ ] `README-DEPLOY.md`
- [ ] `CPANEL-DEPLOY.md`
- [ ] `DEPLOYMENT.md`

## Quick Upload Steps

1. **Create .env file locally:**
   ```bash
   cd accounts/api
   cp env-production.txt .env
   ```

2. **Upload via cPanel File Manager or FTP:**
   - Upload `src/` folder
   - Upload `custom-typings/` folder
   - Upload `package.json`
   - Upload `package-lock.json`
   - Upload `tsconfig.json`
   - Upload `.env` file

3. **Install dependencies on server:**
   - Via cPanel Node.js: Click "Run npm install"
   - OR via SSH: `cd ~/accounts-api && npm install --production`

4. **Create Node.js app in cPanel:**
   - Application root: `~/accounts-api`
   - Startup file: `src/server.ts`
   - Port: `4000`

5. **Set environment variables** (or ensure `.env` is in root)

6. **Start application**

## File Structure After Upload

```
/home/username/accounts-api/
├── src/
│   ├── server.ts
│   ├── db/
│   ├── email/
│   ├── functions/
│   └── ...
├── custom-typings/
├── node_modules/          # Install on server
├── package.json
├── package-lock.json
├── tsconfig.json
└── .env                    # Your configuration
```

## Security Notes

- ✅ `.env` file should NOT be in public_html
- ✅ `.env` file permissions should be 600 or 640
- ✅ Don't upload `.git` directory
- ✅ Don't upload test files

## Verification

After upload, verify:
- [ ] All files uploaded successfully
- [ ] `.env` file is in the correct location
- [ ] Dependencies installed (`node_modules` exists or install via npm)
- [ ] Node.js application created in cPanel
- [ ] Environment variables set
- [ ] Application starts without errors

## Ready to Deploy!

Once all files are uploaded and configured, follow `CPANEL-DEPLOY.md` for complete deployment instructions.
