import type { SubscriptionPlans } from "./plans";
export type SKU = keyof typeof SubscriptionPlans;
export type PricedSKU = Exclude<SKU, 'pro-perpetual'>;
export type SubscriptionStatus = 'active' | 'trialing' | 'past_due' | 'deleted';
export type TierCode = 'pro' | 'team';
export type Interval = 'monthly' | 'annual' | 'perpetual';
export interface SubscriptionPricing {
    product_id: number;
    sku: SKU;
    product_title: string;
    currency: string;
    price: {
        net: number;
    };
    subscription: {
        interval: 'month' | 'year';
    };
}
export type UserAppData = {
    user_id: string;
    email: string;
    feature_flags?: string[];
    banned?: boolean;
    team_subscription?: SubscriptionData;
} & SubscriptionData;
export type UserBillingData = {
    user_id: string;
    email: string;
    banned?: boolean;
    transactions: TransactionData[] | null;
    team_owner?: {
        id: string;
        name?: string;
        error?: string;
    };
    team_members?: Array<{
        id: string;
        name: string;
        locked: boolean;
        error?: string;
    }>;
    locked_license_expiries?: number[];
} & SubscriptionData;
export interface SubscriptionData {
    subscription_status?: SubscriptionStatus;
    subscription_sku?: SKU;
    subscription_expiry?: number;
    update_url?: string;
    cancel_url?: string;
    last_receipt_url?: string;
    /**
     * Deprecated in favour of sub_sku. We can't remove this for a while, as old UIs (pre-3/2023)
     * will not understand subs without it, and will treat them as no subscription at all.
     * @deprecated
     **/
    subscription_plan_id?: number;
    subscription_quantity?: number;
    team_member_ids?: string[];
    subscription_owner_id?: string;
    can_manage_subscription?: boolean;
}
export interface TransactionData {
    order_id: string;
    receipt_url: string;
    sku: SKU;
    created_at: string;
    status: 'completed' | 'refunded' | 'partially_refunded' | 'disputed' | 'waiting' | 'canceled';
    currency: string;
    amount: string;
}
