"use strict";

var _react = _interopRequireDefault(require("react"));
var _enzyme = require("enzyme");
var _testUtils = require("testUtils");
var _auth_button = _interopRequireDefault(require("ui/button/auth_button"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
describe('AuthButton', function () {
  var defaultProps = {
    label: 'label',
    onClick: jest.fn(),
    strategy: 'strategy'
  };
  it('renders correctly', function () {
    (0, _testUtils.expectComponent)( /*#__PURE__*/_react.default.createElement(_auth_button.default, defaultProps)).toMatchSnapshot();
  });
  it('renders with style customizations', function () {
    (0, _testUtils.expectComponent)( /*#__PURE__*/_react.default.createElement(_auth_button.default, _extends({}, defaultProps, {
      icon: "test",
      primaryColor: "primaryColor",
      foregroundColor: "foregroundColor"
    }))).toMatchSnapshot();
  });
  it('should trigger onClick when clicked', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_auth_button.default, defaultProps));
    wrapper.find('a').simulate('click');
    expect(defaultProps.onClick.mock.calls.length).toBe(1);
  });
});
