"use strict";

var _immutable = _interopRequireWildcard(require("immutable"));
var _actions = require("../../../connection/database/actions");
var _store = require("../../../store");
var _captcha = require("../../../connection/captcha");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var webApiMock = function webApiMock() {
  return require('core/web_api');
};
var coreActionsMock = function coreActionsMock() {
  return require('core/actions');
};
jest.mock('core/actions', function () {
  return {
    validateAndSubmit: jest.fn()
  };
});
jest.mock('../../../connection/captcha', function () {
  var originalCaptcha = jest.requireActual('../../../connection/captcha');
  return _objectSpread(_objectSpread({
    __esModule: true
  }, originalCaptcha), {}, {
    swapCaptcha: jest.fn(function (id, flow, wasInvalid, next) {
      next();
    })
  });
});
jest.mock('core/web_api', function () {
  return {
    signUp: jest.fn()
  };
});
describe('database/actions.js', function () {
  beforeEach(function () {
    jest.resetAllMocks();
  });
  it('signUp splits root attributes correctly', function () {
    var id = 1;
    var hookRunner = jest.fn(function (str, m, context, fn) {
      return fn();
    });
    require('connection/database/index').databaseConnectionName = function () {
      return 'test-connection';
    };
    require('connection/database/index').shouldAutoLogin = function () {
      return true;
    };
    var m = _immutable.default.fromJS({
      field: {
        email: {
          value: 'test@email.com'
        },
        password: {
          value: 'testpass'
        },
        family_name: {
          value: 'test-family-name'
        },
        given_name: {
          value: 'test-given-name'
        },
        name: {
          value: 'test-name'
        },
        nickname: {
          value: 'test-nickname'
        },
        picture: {
          value: 'test-pic'
        },
        other_prop: {
          value: 'test-other'
        }
      },
      database: {
        additionalSignUpFields: [{
          name: 'family_name',
          storage: 'root'
        }, {
          name: 'given_name',
          storage: 'root'
        }, {
          name: 'name',
          storage: 'root'
        }, {
          name: 'nickname',
          storage: 'root'
        }, {
          name: 'picture',
          storage: 'root'
        }, {
          name: 'other_prop'
        }]
      },
      core: {
        hookRunner: hookRunner
      }
    });
    (0, _store.swap)(_store.setEntity, 'lock', id, m);
    (0, _actions.signUp)(id);
    var _coreActionsMock = coreActionsMock(),
      validateAndSubmitMock = _coreActionsMock.validateAndSubmit.mock;
    expect(validateAndSubmitMock.calls.length).toBe(1);
    expect(validateAndSubmitMock.calls[0][0]).toBe(id);
    expect(validateAndSubmitMock.calls[0][1]).toContain('email');
    expect(validateAndSubmitMock.calls[0][1]).toContain('password');
    validateAndSubmitMock.calls[0][2](m);
    var _webApiMock = webApiMock(),
      signUpMock = _webApiMock.signUp.mock;
    expect(signUpMock.calls.length).toBe(1);
    expect(signUpMock.calls[0][0]).toBe(id);
    expect(signUpMock.calls[0][1]).toMatchObject({
      connection: 'test-connection',
      email: 'test@email.com',
      password: 'testpass',
      autoLogin: true,
      family_name: 'test-family-name',
      given_name: 'test-given-name',
      name: 'test-name',
      nickname: 'test-nickname',
      picture: 'test-pic',
      user_metadata: {
        other_prop: 'test-other'
      }
    });
  });
  it('runs the signingUp hook on signUp', function () {
    var id = 1;
    require('connection/database/index').databaseConnectionName = function () {
      return 'test-connection';
    };
    require('connection/database/index').shouldAutoLogin = function () {
      return true;
    };
    var hookRunner = jest.fn(function (str, m, context, fn) {
      return fn();
    });
    var m = _immutable.default.fromJS({
      field: {
        email: {
          value: 'test@email.com'
        },
        password: {
          value: 'testpass'
        }
      },
      core: {
        hookRunner: hookRunner
      }
    });
    (0, _store.swap)(_store.setEntity, 'lock', id, m);
    (0, _actions.signUp)(id);
    var _coreActionsMock2 = coreActionsMock(),
      validateAndSubmitMock = _coreActionsMock2.validateAndSubmit.mock;
    validateAndSubmitMock.calls[0][2](m);
    var _webApiMock2 = webApiMock(),
      signUpMock = _webApiMock2.signUp.mock;
    expect(hookRunner).toHaveBeenCalledTimes(1);
    expect(hookRunner).toHaveBeenCalledWith('signingUp', m, null, expect.any(Function));
    expect(signUpMock.calls.length).toBe(1);
    expect(signUpMock.calls[0][0]).toBe(id);
  });
  it('sanitizes additionalSignUp fields using dompurify', function () {
    var id = 1;
    var hookRunner = jest.fn(function (str, m, context, fn) {
      return fn();
    });
    require('connection/database/index').databaseConnectionName = function () {
      return 'test-connection';
    };
    require('connection/database/index').shouldAutoLogin = function () {
      return true;
    };

    // Test different fields using some examples from DOMPurify
    // https://github.com/cure53/DOMPurify#some-purification-samples-please
    var m = _immutable.default.fromJS({
      field: {
        email: {
          value: 'test@email.com'
        },
        password: {
          value: 'testpass'
        },
        family_name: {
          value: 'Test <a href="https://www.google.co.uk">Fake link</a>' // HTML but not malicious
        },
        given_name: {
          value: '<img src=x onerror=alert(1)//>'
        },
        name: {
          value: '<p>abc<iframe//src=jAva&Tab;script:alert(3)>def</p>'
        },
        other_name: {
          value: '<div onclick=alert(0)><form onsubmit=alert(1)><input onfocus=alert(2) name=parentNode>123</form></div>'
        }
      },
      database: {
        additionalSignUpFields: [{
          name: 'family_name',
          storage: 'root'
        }, {
          name: 'given_name',
          storage: 'root'
        }, {
          name: 'name',
          storage: 'root'
        }, {
          name: 'other_name'
        }]
      },
      core: {
        hookRunner: hookRunner
      }
    });
    (0, _store.swap)(_store.setEntity, 'lock', id, m);
    (0, _actions.signUp)(id);
    var _coreActionsMock3 = coreActionsMock(),
      validateAndSubmitMock = _coreActionsMock3.validateAndSubmit.mock;
    validateAndSubmitMock.calls[0][2](m);
    var _webApiMock3 = webApiMock(),
      signUpMock = _webApiMock3.signUp.mock;
    expect(signUpMock.calls[0][1]).toMatchObject({
      connection: 'test-connection',
      email: 'test@email.com',
      password: 'testpass',
      autoLogin: true,
      family_name: 'Test Fake link',
      given_name: '',
      name: 'abc',
      user_metadata: {
        other_name: '123'
      }
    });
  });
  describe('exported functions', function () {
    var id = 2;
    var mCaptcha = _immutable.default.fromJS({
      field: {
        email: {
          value: 'test@email.com'
        },
        password: {
          value: 'testpass'
        },
        family_name: {
          value: 'test-family-name'
        },
        given_name: {
          value: 'test-given-name'
        },
        name: {
          value: 'test-name'
        },
        nickname: {
          value: 'test-nickname'
        },
        picture: {
          value: 'test-pic'
        },
        other_prop: {
          value: 'test-other'
        }
      },
      database: {
        additionalSignUpFields: [{
          name: 'family_name',
          storage: 'root'
        }, {
          name: 'given_name',
          storage: 'root'
        }, {
          name: 'name',
          storage: 'root'
        }, {
          name: 'nickname',
          storage: 'root'
        }, {
          name: 'picture',
          storage: 'root'
        }, {
          name: 'other_prop'
        }]
      },
      captcha: {
        provider: 'auth0'
      },
      passwordResetCaptcha: {
        provider: 'auth0'
      }
    });
    describe('resetPasswordSuccess', function () {
      it('runs swap CAPTCHA', function () {
        (0, _store.swap)(_store.setEntity, 'lock', id, mCaptcha);
        (0, _actions.resetPasswordSuccess)(id);
        expect(_captcha.swapCaptcha.mock.calls.length).toEqual(1);
      });
    });
    describe('showResetPasswordActivity', function () {
      it('runs swap CAPTCHA', function () {
        (0, _store.swap)(_store.setEntity, 'lock', id, mCaptcha);
        (0, _actions.showResetPasswordActivity)(id);
        expect(_captcha.swapCaptcha.mock.calls.length).toEqual(1);
      });
    });
    describe('showLoginActivity', function () {
      it('runs swap CAPTCHA', function () {
        (0, _store.swap)(_store.setEntity, 'lock', id, mCaptcha);
        (0, _actions.showLoginActivity)(id);
        expect(_captcha.swapCaptcha.mock.calls.length).toEqual(1);
      });
    });
    describe('showSignupActivity', function () {
      it('runs swap CAPTCHA', function () {
        (0, _store.swap)(_store.setEntity, 'lock', id, mCaptcha);
        (0, _actions.showSignUpActivity)(id);
        expect(_captcha.swapCaptcha.mock.calls.length).toEqual(1);
      });
    });
  });
});
