"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _immutable = _interopRequireWildcard(require("immutable"));
var _database = require("../../../connection/database");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
describe('database/index.js', function () {
  describe('databaseUsernameValue', function () {
    var getModel = function getModel(email, username, usernameRequired) {
      return _immutable.default.fromJS({
        field: {
          email: {
            value: email
          },
          username: {
            value: username
          }
        },
        core: {
          transient: {
            connections: {
              database: [{
                requireUsername: usernameRequired
              }]
            }
          }
        }
      });
    };
    beforeEach(function () {
      jest.resetAllMocks();
    });
    describe('for database connection without username required', function () {
      var model = getModel('user@auth0.com', null, false);
      it('should get the email', function () {
        expect((0, _database.databaseUsernameValue)(model)).toEqual('user@auth0.com');
      });
    });
    describe('for database connection with username required', function () {
      var model = getModel('user@auth0.com', 'user', true);
      it('should get the username when `emailFirst` is not set', function () {
        expect((0, _database.databaseUsernameValue)(model)).toEqual('user');
      });
      it('should get the username when `emailFirst` is false', function () {
        expect((0, _database.databaseUsernameValue)(model, {
          emailFirst: false
        })).toEqual('user');
      });
      it('should get the email when `emailFirst` is true', function () {
        expect((0, _database.databaseUsernameValue)(model, {
          emailFirst: true
        })).toEqual('user@auth0.com');
      });
      describe('and only email address is filled in', function () {
        var model = getModel('user@auth0.com', null, true);
        it('should get the email address', function () {
          expect((0, _database.databaseUsernameValue)(model)).toEqual('user@auth0.com');
        });
      });
    });
  });
  describe('databaseUsernameStyle', function () {
    beforeEach(function () {
      jest.resetAllMocks();
    });
    it('it should resolve to "username" if a connectionResolver is present', function () {
      var model = _immutable.default.fromJS({
        core: {
          connectionResolver: function connectionResolver() {
            return true;
          },
          transient: {
            connections: {
              database: [{
                requireUsername: false
              }]
            }
          }
        }
      });
      expect((0, _database.databaseUsernameStyle)(model)).toBe('username');
    });
  });
  describe('initDatabase', function () {
    describe('calls initNS with the correct additionalSignUpFields', function () {
      describe('uses the `storage` attribute', function () {
        var model = _immutable.default.fromJS({});
        var modelOut = (0, _database.initDatabase)(model, {
          additionalSignUpFields: [{
            type: 'hidden',
            name: 'hidden_field',
            value: 'hidden_value',
            storage: 'root'
          }]
        });
        var modelOutJS = modelOut.toJS();
        expect(modelOutJS.database.additionalSignUpFields).toEqual([{
          type: 'hidden',
          name: 'hidden_field',
          value: 'hidden_value',
          storage: 'root'
        }]);
      });
      describe('with a valid hidden field', function () {
        var model = _immutable.default.fromJS({});
        var modelOut = (0, _database.initDatabase)(model, {
          additionalSignUpFields: [{
            type: 'hidden',
            name: 'hidden_field',
            value: 'hidden_value'
          }]
        });
        var modelOutJS = modelOut.toJS();
        expect(modelOutJS.field).toEqual({
          hidden_field: {
            showInvalid: false,
            valid: true,
            value: 'hidden_value'
          }
        });
        expect(modelOutJS.database.additionalSignUpFields).toEqual([{
          type: 'hidden',
          name: 'hidden_field',
          value: 'hidden_value'
        }]);
      });
      describe('with a hidden field without a value', function () {
        var model = _immutable.default.fromJS({});
        var modelOut = (0, _database.initDatabase)(model, {
          additionalSignUpFields: [{
            type: 'hidden',
            name: 'hidden_field'
          }]
        });
        expect(modelOut.toJS().database.additionalSignUpFields.length).toBe(0);
      });
    });
  });
});
