"use strict";

var _react = _interopRequireDefault(require("react"));
var _testUtils = require("testUtils");
var _immutable = _interopRequireDefault(require("immutable"));
var _field = require("../../../field");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
jest.mock('connection/database/reset_password_pane', function () {
  return (0, _testUtils.mockComponent)('reset_password_pane');
});
var getScreen = function getScreen() {
  var ResetPasswordScreen = require('connection/database/reset_password').default;
  return new ResetPasswordScreen();
};
var getComponent = function getComponent() {
  var screen = getScreen();
  return screen.render();
};
describe('ResetPasswordScreen', function () {
  beforeEach(function () {
    jest.resetModules();
    jest.mock('connection/database/index', function () {
      return {
        databaseUsernameValue: function databaseUsernameValue(model, options) {
          expect(options.emailFirst).toBe(true);
          return 'foo@test.com';
        }
      };
    });
    jest.mock('connection/enterprise', function () {
      return {
        isEnterpriseDomain: function isEnterpriseDomain() {
          return true;
        }
      };
    });
    jest.mock('i18n', function () {
      return {
        str: function str(_, keys) {
          return keys.join(',');
        }
      };
    });
    jest.mock('core/index', function () {
      return {
        id: function id() {
          return 'id';
        },
        setGlobalError: 'setGlobalError',
        clearGlobalError: 'clearGlobalError',
        connectionResolver: jest.fn().mockReturnValue(undefined),
        ui: {
          allowAutocomplete: function allowAutocomplete() {
            return false;
          }
        },
        submitting: function submitting() {
          return false;
        }
      };
    });
    jest.mock('store/index', function () {
      return {
        swap: jest.fn(),
        updateEntity: 'updateEntity'
      };
    });
  });
  it('isSubmitDisabled returns true when `isEnterpriseDomain` is true', function () {
    jest.useFakeTimers();
    require('connection/enterprise').isEnterpriseDomain = function () {
      return true;
    };
    var screen = getScreen();
    expect(screen.isSubmitDisabled()).toBe(true);
    jest.advanceTimersByTime(50);
    expect(require('store/index').swap.mock.calls[0]).toMatchSnapshot();
  });
  it('isSubmitDisabled returns false when `isEnterpriseDomain` is false', function () {
    require('connection/enterprise').isEnterpriseDomain = function () {
      return false;
    };
    var screen = getScreen();
    expect(screen.isSubmitDisabled()).toBe(false);
    expect(require('store/index').swap.mock.calls[0]).toMatchSnapshot();
  });
  describe('a custom connection resolver is being used', function () {
    var lock;
    var i18n;
    beforeEach(function () {
      lock = _immutable.default.fromJS({
        id: '__lock-id__'
      });
      i18n = {
        html: jest.fn(),
        str: jest.fn()
      };
    });
    it('copies the username to the email field if an email address was entered', function () {
      require('core/index').connectionResolver.mockReturnValue(function () {
        return function () {
          return true;
        };
      });
      var store = require('store/index');
      var Component = getComponent();

      // Set a field on Lock to set the username field, then check it was set as the email
      var l = (0, _field.setField)(lock, 'username', 'test@test.com');
      (0, _testUtils.expectComponent)( /*#__PURE__*/_react.default.createElement(Component, {
        i18n: i18n,
        model: l
      })).toMatchSnapshot();
      expect(store.swap).toHaveBeenCalledWith('updateEntity', 'lock', 'id', expect.anything(), 'test@test.com', false);
    });
    it('sets the email field to a blank value if username is not an email address', function () {
      require('core/index').connectionResolver.mockReturnValue(function () {
        return function () {
          return true;
        };
      });
      var store = require('store/index');
      var Component = getComponent();

      // Set a field on Lock to set the username field, then check it was set as the email
      var l = (0, _field.setField)(lock, 'username', 'some-username');
      (0, _testUtils.expectComponent)( /*#__PURE__*/_react.default.createElement(Component, {
        i18n: i18n,
        model: l
      })).toMatchSnapshot();
      expect(store.swap).toHaveBeenCalledWith('updateEntity', 'lock', 'id', expect.anything(), '', false);
    });
  });
});
