"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _react = _interopRequireDefault(require("react"));
var _testUtils = require("testUtils");
var _immutable = _interopRequireDefault(require("immutable"));
var i18n = _interopRequireWildcard(require("../../../i18n"));
var _hrd_pane = _interopRequireDefault(require("../../../connection/enterprise/hrd_pane"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
var lock = _immutable.default.fromJS({
  id: '__lock-id__'
});
jest.mock('core/index');
describe('HRDPane', function () {
  var defaultProps = {
    model: lock,
    header: /*#__PURE__*/_react.default.createElement("header", null),
    i18n: i18n,
    passwordInputPlaceholder: 'password',
    usernameInputPlaceholder: 'username'
  };
  beforeEach(function () {
    jest.resetAllMocks();
  });
  it('renders correctly', function () {
    (0, _testUtils.expectShallowComponent)( /*#__PURE__*/_react.default.createElement(_hrd_pane.default, defaultProps)).toMatchSnapshot();
  });
  it('renders the captcha if required', function () {
    require('core/index').captcha.mockReturnValue({
      get: function get() {
        return true;
      }
    });
    (0, _testUtils.expectShallowComponent)( /*#__PURE__*/_react.default.createElement(_hrd_pane.default, defaultProps)).toMatchSnapshot();
  });
});
