"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _react = _interopRequireDefault(require("react"));
var _testUtils = require("testUtils");
var _immutable = _interopRequireDefault(require("immutable"));
var _data_utils = require("../../../utils/data_utils");
var i18n = _interopRequireWildcard(require("../../../i18n"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
var _dataFns = (0, _data_utils.dataFns)(['i18n']),
  set = _dataFns.set;
jest.mock('engine/classic');
jest.mock('connection/enterprise/hrd_pane', function () {
  return (0, _testUtils.mockComponent)('hrd_pane');
});
jest.mock('connection/enterprise', function () {
  return {
    enterpriseDomain: jest.fn(function () {
      return 'domain.com';
    })
  };
});
var getComponent = function getComponent() {
  var HRDScreen = require('connection/enterprise/hrd_screen').default;
  var screen = new HRDScreen();
  return screen.render();
};
describe('HRDScreen Component', function () {
  var i18nProp;
  var lock;
  beforeEach(function () {
    lock = _immutable.default.fromJS({
      id: '__lock-id__'
    });
    jest.resetModules();
    var lang = _immutable.default.fromJS({
      enterpriseLoginIntructions: 'Login with your corporate credentials.',
      enterpriseActiveLoginInstructions: 'Please enter your corporate credentials at %s.'
    });
    lock = set(lock, 'strings', lang);
    i18nProp = {
      str: function str(keypath) {
        for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          args[_key - 1] = arguments[_key];
        }
        return i18n.str(lock, keypath, args);
      }
    };
  });
  it('renders correctly when there is an enterprise domain', function () {
    var Component = getComponent();
    (0, _testUtils.expectComponent)( /*#__PURE__*/_react.default.createElement(Component, {
      model: lock,
      i18n: i18nProp
    })).toMatchSnapshot();
  });
  it('renders correctly when there is no enterprise domain', function () {
    require('connection/enterprise').enterpriseDomain.mockImplementation(function () {
      return null;
    });
    var Component = getComponent();
    (0, _testUtils.expectComponent)( /*#__PURE__*/_react.default.createElement(Component, {
      model: lock,
      i18n: i18nProp
    })).toMatchSnapshot();
  });
});
