"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _react = _interopRequireDefault(require("react"));
var _testUtils = require("testUtils");
var _immutable = _interopRequireDefault(require("immutable"));
var _field = require("../../../field");
var i18n = _interopRequireWildcard(require("../../../i18n"));
var _testUtils2 = require("../../testUtils");
var _data_utils = require("../../../utils/data_utils");
var _phone_number = require("../../../field/phone_number");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
var _dataFns = (0, _data_utils.dataFns)(['i18n']),
  set = _dataFns.set;
jest.mock('engine/classic');
jest.mock('field/vcode/vcode_pane', function () {
  return (0, _testUtils.mockComponent)('vcode_pane');
});
jest.mock('field/phone-number/locations', function () {
  return {
    __esModule: true,
    default: [['United Kingdom', 'UK', '+44']]
  };
});
jest.mock('connection/passwordless/index', function () {
  return {
    isEmail: jest.fn()
  };
});
var getComponent = function getComponent() {
  var VCodeScreen = require('connection/passwordless/ask_vcode').default;
  var screen = new VCodeScreen();
  return screen.render();
};
describe('AskVCode', function () {
  var lock;
  var i18nProp;
  beforeEach(function () {
    lock = _immutable.default.fromJS({
      id: '__lock-id__'
    });
    jest.resetModules();
    var lang = _immutable.default.fromJS({
      passwordlessEmailCodeInstructions: 'An email with the code has been sent to %s.',
      passwordlessSMSCodeInstructions: 'An SMS with the code has been sent to %s.'
    });
    lock = set(lock, 'strings', lang);
    i18nProp = {
      str: function str(keypath) {
        for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          args[_key - 1] = arguments[_key];
        }
        return i18n.str(lock, keypath, args);
      }
    };
  });
  it('renders correctly when logging in with email', function () {
    require('connection/passwordless/index').isEmail.mockImplementation(function () {
      return true;
    });
    var Component = getComponent();
    var l = (0, _field.setField)(lock, 'email', 'test@user.com');
    (0, _testUtils2.expectComponent)( /*#__PURE__*/_react.default.createElement(Component, {
      model: l,
      i18n: i18nProp
    })).toMatchSnapshot();
  });
  it('renders correctly when logging in with a phone number', function () {
    require('connection/passwordless/index').isEmail.mockImplementation(function () {
      return false;
    });
    var Component = getComponent();
    var l = (0, _phone_number.setPhoneNumber)(lock, '456 789');
    l = (0, _phone_number.initLocation)(l, 'UK');
    (0, _testUtils2.expectComponent)( /*#__PURE__*/_react.default.createElement(Component, {
      model: l,
      i18n: i18nProp
    })).toMatchSnapshot();
  });
});
