"use strict";

var _actions = require("../../core/actions");
var _testUtils = require("testUtils");
var l = _interopRequireWildcard(require("core/index"));
var _index2 = require("store/index");
var _web_api = _interopRequireDefault(require("../../core/web_api"));
var _immutable = require("immutable");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
jest.mock('../../core/web_api', function () {
  return {
    __esModule: true,
    default: {
      logIn: jest.fn(),
      checkSession: jest.fn()
    }
  };
});
jest.mock('store/index', function () {
  return _defineProperty({
    read: jest.fn(function () {
      return 'model';
    }),
    getEntity: 'getEntity',
    swap: jest.fn(),
    updateEntity: 'updateEntity'
  }, "read", jest.fn());
});
jest.mock('core/index');
describe('core.actions', function () {
  beforeEach(function () {
    jest.resetAllMocks();
    l.submitting.mockReturnValue(true);
    l.id.mockReturnValue('id');
    l.auth.params.mockReturnValue((0, _immutable.fromJS)({}));
  });
  describe('checkSession', function () {
    it('should set submitting on start', function () {
      (0, _actions.checkSession)('id', 'params', 'cb');
      var _require = require('store/index'),
        read = _require.read,
        swap = _require.swap;
      (0, _testUtils.expectMockToMatch)(read, 1);
      (0, _testUtils.expectMockToMatch)(swap, 1);
      swap.mock.calls[0][3]('model');
      (0, _testUtils.expectMockToMatch)(require('core/index').setSubmitting, 1);
    });
  });
  describe('logIn', function () {
    it('run the loggingIn hook', function (done) {
      var m = {};
      _index2.read.mockReturnValue(m);
      _web_api.default.logIn.mockImplementation(function (id, params, authParams, cb) {
        cb(null, {});
        done();
      });
      l.runHook.mockImplementation(function (m, hook, context, fn) {
        expect(hook).toEqual('loggingIn');
        fn();
      });
      (0, _actions.logIn)();
    });
    it('should display an error if one was thrown from the hook', function (done) {
      var m = {};
      _index2.read.mockReturnValue(m);
      var store = require('store/index');
      store.swap.mockImplementation(function (entity, n, id, fn, value, error) {
        if (error) {
          expect(error).toEqual('This is a hook error');
          done();
        }
      });
      l.loginErrorMessage.mockImplementation(function (m, error) {
        return error.description;
      });
      l.runHook.mockImplementation(function (m, hook, fn) {
        expect(hook).toEqual('loggingIn');
        throw {
          code: 'hook_error',
          description: 'This is a hook error'
        };
      });
      (0, _actions.logIn)();
    });
  });
});
