"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var getInitTenant = function getInitTenant() {
  return require('core/tenant/index').initTenant;
};
var CLIENT_ID = 'client_id';
var runTest = function runTest(initTenant, mockDataFns, client) {
  initTenant({}, CLIENT_ID, client);
  expect(mockDataFns.initNS.mock.calls.length).toBe(1);
  var tenantInfo = mockDataFns.initNS.mock.calls[0][1].toJS();
  expect(tenantInfo).toMatchSnapshot();
};
describe('initTenant()', function () {
  var initTenant;
  var mockDataFns;
  beforeEach(function () {
    jest.resetModules();
    mockDataFns = {
      initNS: jest.fn(),
      get: jest.fn()
    };
    jest.mock('utils/data_utils', function () {
      return {
        dataFns: function dataFns() {
          return mockDataFns;
        }
      };
    });
    jest.mock('core/index', function () {
      return {
        findConnection: jest.fn()
      };
    });
    initTenant = getInitTenant();
  });
  describe('with database connection', function () {
    it('maps connection correctly with defaults', function () {
      var client = {
        connections: {
          database: [{
            name: 'test-connection-database',
            strategy: 'auth0'
          }]
        }
      };
      runTest(initTenant, mockDataFns, client);
    });
    it('maps connection correctly with all the properties', function () {
      var client = {
        connections: {
          database: [{
            allowForgot: false,
            allowSignup: false,
            name: 'test-connection-database',
            requiresUsername: true,
            strategy: 'auth0',
            validation: {
              username: {
                min: 4,
                max: 5
              }
            }
          }]
        }
      };
      runTest(initTenant, mockDataFns, client);
    });
    it('maps password policy correctly', function () {
      var client = {
        connections: {
          database: [{
            allowForgot: false,
            allowSignup: false,
            name: 'test-connection-database',
            requiresUsername: true,
            strategy: 'auth0',
            validation: {
              passwordPolicy: 'low',
              //minLength: 6
              username: {
                min: 4,
                max: 5
              }
            }
          }]
        }
      };
      runTest(initTenant, mockDataFns, client);
    });
    it('fixes validation when values are not numbers', function () {
      var client = {
        connections: {
          database: [{
            allowForgot: false,
            allowSignup: false,
            name: 'test-connection-database',
            requiresUsername: true,
            strategy: 'auth0',
            validation: {
              username: {
                min: 'foo',
                max: 'bar'
              }
            }
          }]
        }
      };
      runTest(initTenant, mockDataFns, client);
    });
    it('fixes validation when username.min > username.max', function () {
      var client = {
        connections: {
          database: [{
            allowForgot: false,
            allowSignup: false,
            name: 'test-connection-database',
            requiresUsername: true,
            strategy: 'auth0',
            validation: {
              username: {
                min: 5,
                max: 4
              }
            }
          }]
        }
      };
      runTest(initTenant, mockDataFns, client);
    });
  });
  describe('with enterprise connection', function () {
    it('maps connection correctly', function () {
      var client = {
        connections: {
          enterprise: [{
            name: 'test-connection-enterprise',
            domains: 'domains',
            strategy: 'auth0'
          }]
        }
      };
      runTest(initTenant, mockDataFns, client);
    });
  });
  describe('with other connection types', function () {
    it('maps connection correctly', function () {
      var client = {
        connections: {
          social: [{
            name: 'test-connection-other_type',
            strategy: 'auth0'
          }],
          unknown: [{
            name: '??',
            strategy: '??'
          }]
        }
      };
      runTest(initTenant, mockDataFns, client);
    });
  });
  describe('with passwordless connection', function () {
    it('maps connection correctly', function () {
      var client = {
        connections: {
          passwordless: [{
            name: 'sms',
            strategy: 'sms'
          }]
        }
      };
      runTest(initTenant, mockDataFns, client);
    });
  });
  test('filters clientConnections', function () {
    var client = {
      connections: {
        database: [{
          name: 'test-connection-database',
          strategy: 'auth0'
        }, {
          name: 'test-not-this-one',
          strategy: 'auth0'
        }]
      },
      clientsConnections: _defineProperty({}, CLIENT_ID, ['test-connection-database'])
    };
    runTest(initTenant, mockDataFns, client);
  });
});
