"use strict";

var _web_api = _interopRequireDefault(require("../../core/web_api"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
describe('Auth0WebApi', function () {
  var originalWindow;
  var LOCK_ID = 'lock-id';
  var CLIENT_ID = 'client-id';
  var DEFAULT_DOMAIN = 'test.com';
  var client = function client() {
    return _web_api.default.clients[LOCK_ID];
  };
  beforeEach(function () {
    originalWindow = window.window;
  });
  afterEach(function () {
    window.window = originalWindow;
  });
  describe('setupClient', function () {
    it('sets the correct options when is on the hosted login page', function () {
      delete window.location;
      window.location = _objectSpread(_objectSpread({}, originalWindow.location), {}, {
        host: DEFAULT_DOMAIN,
        search: ''
      });
      _web_api.default.setupClient(LOCK_ID, CLIENT_ID, DEFAULT_DOMAIN, {
        redirect: true
      });
      expect(client()).toEqual(expect.objectContaining({
        isUniversalLogin: true,
        domain: DEFAULT_DOMAIN,
        authOpt: {
          popup: false
        }
      }));
    });
    it('sets redirect: true when on the same origin as the specified domain', function () {
      delete window.location;
      window.location = _objectSpread(_objectSpread({}, originalWindow.location), {}, {
        host: DEFAULT_DOMAIN,
        search: ''
      });
      _web_api.default.setupClient(LOCK_ID, CLIENT_ID, DEFAULT_DOMAIN, {});
      expect(client().authOpt.popup).toBe(false);
    });
    it('sets redirect: false when on a different origin as the specified domain', function () {
      delete window.location;
      window.location = _objectSpread(_objectSpread({}, originalWindow.location), {}, {
        host: 'test-other.com',
        search: ''
      });
      _web_api.default.setupClient(LOCK_ID, CLIENT_ID, DEFAULT_DOMAIN, {});
      expect(client().authOpt.popup).toBe(true);
    });
    it('forces popup and sso mode for cordova, only when not running in the hosted environment', function () {
      delete window.location;
      window.location = _objectSpread(_objectSpread({}, originalWindow.location), {}, {
        host: DEFAULT_DOMAIN,
        search: ''
      });
      window.cordova = true;
      _web_api.default.setupClient(LOCK_ID, CLIENT_ID, DEFAULT_DOMAIN, {});
      expect(client().authOpt.popup).toBe(false);
      expect(client().authOpt.sso).toBeUndefined();
    });
    it('forces popup and sso mode for electron, only when not running in the hosted environment', function () {
      delete window.location;
      window.location = _objectSpread(_objectSpread({}, originalWindow.location), {}, {
        host: DEFAULT_DOMAIN,
        search: ''
      });
      window.electron = true;
      _web_api.default.setupClient(LOCK_ID, CLIENT_ID, DEFAULT_DOMAIN, {});
      expect(client().authOpt.popup).toBe(false);
      expect(client().authOpt.sso).toBeUndefined();
    });
  });
});
