"use strict";

var _react = _interopRequireDefault(require("react"));
var _testUtils = require("testUtils");
var _testUtils2 = require("../../testUtils");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
jest.mock('field/email/email_pane', function () {
  return (0, _testUtils.mockComponent)('email_pane');
});
jest.mock('field/password/password_pane', function () {
  return (0, _testUtils.mockComponent)('password_pane');
});
jest.mock('field/username/username_pane', function () {
  return (0, _testUtils.mockComponent)('username_pane');
});
jest.mock('field/custom_input', function () {
  return (0, _testUtils.mockComponent)('custom_input');
});
jest.mock('core/index', function () {
  return {
    captcha: jest.fn()
  };
});
jest.mock('engine/classic', function () {
  return {
    isSSOEnabled: jest.fn()
  };
});
jest.mock('connection/enterprise', function () {
  return {
    isHRDDomain: jest.fn()
  };
});
var getComponent = function getComponent() {
  return require('engine/classic/sign_up_pane').default;
};
describe('SignUpPane', function () {
  beforeEach(function () {
    jest.resetModules();
    jest.mock('connection/database/index', function () {
      return {
        additionalSignUpFields: function additionalSignUpFields() {
          return [];
        },
        databaseConnectionRequiresUsername: function databaseConnectionRequiresUsername() {
          return false;
        },
        passwordStrengthPolicy: function passwordStrengthPolicy() {
          return 'passwordStrengthPolicy';
        },
        signUpFieldsStrictValidation: function signUpFieldsStrictValidation() {
          return true;
        },
        databaseUsernameValue: function databaseUsernameValue() {
          return null;
        }
      };
    });
  });
  var defaultProps = {
    i18n: {
      str: function str() {
        for (var _len = arguments.length, keys = new Array(_len), _key = 0; _key < _len; _key++) {
          keys[_key] = arguments[_key];
        }
        return keys.join(',');
      },
      html: function html() {
        for (var _len2 = arguments.length, keys = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
          keys[_key2] = arguments[_key2];
        }
        return keys.join(',');
      }
    },
    model: 'model',
    emailInputPlaceholder: 'emailInputPlaceholder',
    onlyEmail: true,
    passwordInputPlaceholder: 'passwordInputPlaceholder',
    passwordStrengthMessages: 'passwordStrengthMessages',
    usernameInputPlaceholder: 'usernameInputPlaceholder',
    strictValidation: false
  };
  it('renders only email by default', function () {
    var Component = getComponent();
    (0, _testUtils.expectComponent)( /*#__PURE__*/_react.default.createElement(Component, defaultProps)).toMatchSnapshot();
  });
  it('shows header when instructions are available', function () {
    var Component = getComponent();
    (0, _testUtils.expectComponent)( /*#__PURE__*/_react.default.createElement(Component, _extends({}, defaultProps, {
      instructions: "instructions"
    }))).toMatchSnapshot();
  });
  it('shows the Captcha pane', function () {
    require('core/index').captcha.mockReturnValue({
      get: function get() {
        return true;
      }
    });
    require('engine/classic').isSSOEnabled.mockReturnValue(false);
    var Component = getComponent();
    (0, _testUtils2.expectShallowComponent)( /*#__PURE__*/_react.default.createElement(Component, defaultProps)).toMatchSnapshot();
  });
  it('hides the Captcha pane for SSO connections', function () {
    require('core/index').captcha.mockReturnValue({
      get: function get() {
        return true;
      }
    });
    require('engine/classic').isSSOEnabled.mockReturnValue(true);
    var Component = getComponent();
    (0, _testUtils2.expectShallowComponent)( /*#__PURE__*/_react.default.createElement(Component, defaultProps)).toMatchSnapshot();
  });
  it('shows the Captcha pane for SSO (ADFS) connections', function () {
    require('core/index').captcha.mockReturnValue({
      get: function get() {
        return true;
      }
    });
    require('engine/classic').isSSOEnabled.mockReturnValue(true);
    require('connection/enterprise').isHRDDomain.mockReturnValue(true);
    var Component = getComponent();
    (0, _testUtils2.expectShallowComponent)( /*#__PURE__*/_react.default.createElement(Component, defaultProps)).toMatchSnapshot();
  });
  describe('onlyEmail is false', function () {
    it('shows PasswordPane', function () {
      var Component = getComponent();
      (0, _testUtils.expectComponent)( /*#__PURE__*/_react.default.createElement(Component, _extends({}, defaultProps, {
        onlyEmail: false
      }))).toMatchSnapshot();
    });
    it('shows custom fields when additionalSignUpFields returns additional fields', function () {
      require('connection/database/index').additionalSignUpFields = function () {
        return [{
          get: function get(key) {
            return "".concat(key, "1");
          }
        }, {
          get: function get(key) {
            return "".concat(key, "2");
          }
        }];
      };
      var Component = getComponent();
      (0, _testUtils.expectComponent)( /*#__PURE__*/_react.default.createElement(Component, _extends({}, defaultProps, {
        onlyEmail: false
      }))).toMatchSnapshot();
    });
    it('shows UsernamePane when databaseConnectionRequiresUsername is true and signUpHideUsernameField is false', function () {
      require('connection/database/index').databaseConnectionRequiresUsername = function () {
        return true;
      };
      require('connection/database/index').signUpHideUsernameField = function () {
        return false;
      };
      var Component = getComponent();
      (0, _testUtils.expectComponent)( /*#__PURE__*/_react.default.createElement(Component, _extends({}, defaultProps, {
        onlyEmail: false
      }))).toMatchSnapshot();
    });
    it('hide UsernamePane when databaseConnectionRequiresUsername is true and signUpHideUsernameField is true', function () {
      require('connection/database/index').databaseConnectionRequiresUsername = function () {
        return true;
      };
      require('connection/database/index').signUpHideUsernameField = function () {
        return true;
      };
      var Component = getComponent();
      (0, _testUtils.expectComponent)( /*#__PURE__*/_react.default.createElement(Component, defaultProps)).toMatchSnapshot();
    });
  });
});
