"use strict";

var _react = _interopRequireDefault(require("react"));
var _enzyme = require("enzyme");
var _immutable = _interopRequireDefault(require("immutable"));
var _captcha_pane = _interopRequireDefault(require("../../field/captcha/captcha_pane"));
var _third_party_captcha = require("../../field/captcha/third_party_captcha");
var _captcha_input = _interopRequireDefault(require("../../ui/input/captcha_input"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
var createLockMock = function createLockMock() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
    _ref$provider = _ref.provider,
    provider = _ref$provider === void 0 ? 'auth0' : _ref$provider,
    _ref$required = _ref.required,
    required = _ref$required === void 0 ? true : _ref$required,
    _ref$siteKey = _ref.siteKey,
    siteKey = _ref$siteKey === void 0 ? '' : _ref$siteKey,
    _ref$clientSubdomain = _ref.clientSubdomain,
    clientSubdomain = _ref$clientSubdomain === void 0 ? '' : _ref$clientSubdomain;
  return _immutable.default.fromJS({
    id: '__lock-id__',
    core: {
      captcha: {
        provider: provider,
        siteKey: siteKey,
        clientSubdomain: clientSubdomain,
        required: required
      }
    }
  });
};
var createI18nMock = function createI18nMock() {
  return {
    str: jest.fn().mockReturnValue('My i18N Compliant Language')
  };
};
describe('CaptchaPane', function () {
  describe('CaptchaInput', function () {
    var wrapper;
    beforeAll(function () {
      var lockMock = createLockMock();
      var i8nMock = createI18nMock();
      var onReloadMock = jest.fn();
      wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_captcha_pane.default, {
        lock: lockMock,
        onReload: onReloadMock,
        i18n: i8nMock
      }));
    });
    it('should render CaptchaInput if no provider is specified', function () {
      expect(wrapper.find(_captcha_input.default)).toHaveLength(1);
    });
  });
  describe('recaptchav2', function () {
    var wrapper;
    beforeAll(function () {
      var lockMock = createLockMock({
        provider: 'recaptcha_v2',
        siteKey: 'mySiteKey'
      });
      var i8nMock = createI18nMock();
      var onReloadMock = jest.fn();
      wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_captcha_pane.default, {
        lock: lockMock,
        onReload: onReloadMock,
        i18n: i8nMock
      }));
    });
    it('should render ThirdPartyCaptcha if provider is recaptchav2', function () {
      expect(wrapper.find(_third_party_captcha.ThirdPartyCaptcha)).toHaveLength(1);
    });
    it('should pass the sitekey', function () {
      expect(wrapper.find(_third_party_captcha.ThirdPartyCaptcha).props().sitekey).toBe('mySiteKey');
    });
  });
  describe('friendly captcha', function () {
    var wrapper;
    beforeAll(function () {
      var lockMock = createLockMock({
        provider: 'friendly_captcha',
        siteKey: 'mySiteKey'
      });
      var i8nMock = createI18nMock();
      var onReloadMock = jest.fn();
      wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_captcha_pane.default, {
        lock: lockMock,
        onReload: onReloadMock,
        i18n: i8nMock
      }));
    });
    it('should render ThirdPartyCaptcha if provider is friendly captcha', function () {
      expect(wrapper.find(_third_party_captcha.ThirdPartyCaptcha)).toHaveLength(1);
    });
    it('should pass the sitekey', function () {
      expect(wrapper.find(_third_party_captcha.ThirdPartyCaptcha).props().sitekey).toBe('mySiteKey');
    });
  });
  describe('hcaptcha', function () {
    var wrapper;
    beforeAll(function () {
      var lockMock = createLockMock({
        provider: 'hcaptcha',
        siteKey: 'mySiteKey'
      });
      var i8nMock = createI18nMock();
      var onReloadMock = jest.fn();
      wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_captcha_pane.default, {
        lock: lockMock,
        onReload: onReloadMock,
        i18n: i8nMock
      }));
    });
    it('should render ThirdPartyCaptcha if provider is hCaptcha', function () {
      expect(wrapper.find(_third_party_captcha.ThirdPartyCaptcha)).toHaveLength(1);
    });
    it('should pass the sitekey', function () {
      expect(wrapper.find(_third_party_captcha.ThirdPartyCaptcha).props().sitekey).toBe('mySiteKey');
    });
  });
  describe('auth0_v2', function () {
    var wrapper;
    beforeAll(function () {
      var lockMock = createLockMock({
        provider: 'auth0_v2',
        siteKey: 'mySiteKey'
      });
      var i8nMock = createI18nMock();
      var onReloadMock = jest.fn();
      wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_captcha_pane.default, {
        lock: lockMock,
        onReload: onReloadMock,
        i18n: i8nMock
      }));
    });
    it('should render ThirdPartyCaptcha if provider is auth0_v2', function () {
      expect(wrapper.find(_third_party_captcha.ThirdPartyCaptcha)).toHaveLength(1);
    });
    it('should pass the sitekey', function () {
      expect(wrapper.find(_third_party_captcha.ThirdPartyCaptcha).props().sitekey).toBe('mySiteKey');
    });
  });
  describe('recaptcha enterprise', function () {
    var wrapper;
    beforeAll(function () {
      var lockMock = createLockMock({
        provider: 'recaptcha_enterprise',
        siteKey: 'mySiteKey'
      });
      var i8nMock = createI18nMock();
      var onReloadMock = jest.fn();
      wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_captcha_pane.default, {
        lock: lockMock,
        onReload: onReloadMock,
        i18n: i8nMock
      }));
    });
    it('should render ThirdPartyCaptcha if provider is recaptcha_enterprise', function () {
      expect(wrapper.find(_third_party_captcha.ThirdPartyCaptcha)).toHaveLength(1);
    });
    it('should pass the sitekey', function () {
      expect(wrapper.find(_third_party_captcha.ThirdPartyCaptcha).props().sitekey).toBe('mySiteKey');
    });
  });
  describe('Arkose', function () {
    var wrapper;
    beforeAll(function () {
      var lockMock = createLockMock({
        provider: 'arkose',
        siteKey: 'mySiteKey',
        clientSubdomain: 'client-api'
      });
      var i8nMock = createI18nMock();
      var onReloadMock = jest.fn();
      wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_captcha_pane.default, {
        lock: lockMock,
        onReload: onReloadMock,
        i18n: i8nMock
      }));
    });
    it('should render ThirdPartyCaptcha if provider is Arkose', function () {
      expect(wrapper.find(_third_party_captcha.ThirdPartyCaptcha)).toHaveLength(1);
    });
    it('should pass the sitekey', function () {
      expect(wrapper.find(_third_party_captcha.ThirdPartyCaptcha).props().sitekey).toBe('mySiteKey');
    });
    it('should pass the clientSubdomain', function () {
      expect(wrapper.find(_third_party_captcha.ThirdPartyCaptcha).props().clientSubdomain).toBe('client-api');
    });
  });
});
