"use strict";

var _react = _interopRequireDefault(require("react"));
var _testUtils = require("testUtils");
var _third_party_captcha = require("../../../field/captcha/third_party_captcha");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
describe('Recaptcha v2', function () {
  var component = /*#__PURE__*/_react.default.createElement(_third_party_captcha.ThirdPartyCaptcha, {
    provider: 'recaptcha_v2',
    hl: "en",
    sitekey: 'mySiteKey'
  });
  it('should match the snapshot', function () {
    (0, _testUtils.expectComponent)(component).toMatchSnapshot();
  });
  it('injects the script', function () {
    var script = _toConsumableArray(window.document.querySelectorAll('script')).find(function (s) {
      return s.src.startsWith("https://www.recaptcha.net/recaptcha/api.js");
    });
    expect(script).not.toBeUndefined();
  });
});
