"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _react = _interopRequireDefault(require("react"));
var _enzyme = require("enzyme");
var _testUtils = require("react-dom/test-utils");
var _immutable = _interopRequireDefault(require("immutable"));
var l = _interopRequireWildcard(require("../../../core/index"));
var _third_party_captcha = require("../../../field/captcha/third_party_captcha");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var createLockMock = function createLockMock() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
    _ref$provider = _ref.provider,
    provider = _ref$provider === void 0 ? 'auth0' : _ref$provider,
    _ref$required = _ref.required,
    required = _ref$required === void 0 ? true : _ref$required,
    _ref$siteKey = _ref.siteKey,
    siteKey = _ref$siteKey === void 0 ? '' : _ref$siteKey,
    _ref$clientSubdomain = _ref.clientSubdomain,
    clientSubdomain = _ref$clientSubdomain === void 0 ? '' : _ref$clientSubdomain;
  return _immutable.default.fromJS({
    id: '__lock-id__',
    core: {
      captcha: {
        provider: provider,
        siteKey: siteKey,
        clientSubdomain: clientSubdomain,
        required: required
      }
    }
  });
};
describe('ThirdPartyCaptcha', function () {
  var prevWindow;
  var counter = 0;
  beforeAll(function () {
    prevWindow = global.window;
    global.window.grecaptcha = {
      render: jest.fn(),
      enterprise: {
        render: jest.fn()
      }
    };
    global.window.hcaptcha = {
      render: jest.fn()
    };
    global.window.friendlyChallenge = {
      WidgetInstance: jest.fn().mockImplementation(function () {
        var _jest;
        return (_jest = jest).fn.apply(_jest, arguments);
      })
    };
    global.window.turnstile = {
      render: jest.fn(),
      reset: function reset() {
        var _global$window$turnst;
        (_global$window$turnst = global.window.turnstile).render.apply(_global$window$turnst, _toConsumableArray(global.window.turnstile.render.mock.calls[counter]));
        counter++;
      }
    };
  });
  afterAll(function () {
    global.window = prevWindow;
  });
  describe('recaptchav2', function () {
    var wrapper;
    beforeAll(function () {
      var lockMock = createLockMock({
        provider: 'recaptcha_v2',
        siteKey: 'mySiteKey'
      });
      var captcha = l.captcha(lockMock);
      wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_third_party_captcha.ThirdPartyCaptcha, {
        provider: captcha.get('provider'),
        sitekey: captcha.get('siteKey'),
        clientSubdomain: captcha.get('clientSubdomain'),
        hl: 'en',
        isValid: true,
        value: undefined
      })).instance();
      (0, _testUtils.act)(function () {
        var injectCaptchaScriptSpy = jest.spyOn(wrapper, 'injectCaptchaScript');
        wrapper.componentDidMount();
        injectCaptchaScriptSpy.mock.calls[0][0]();
      });
    });
    it('should call render with the correct renderParams', function () {
      var renderParams = global.window.grecaptcha.render.mock.calls[0][1];
      expect(renderParams).toEqual({
        sitekey: 'mySiteKey',
        callback: expect.any(Function),
        'expired-callback': expect.any(Function),
        'error-callback': expect.any(Function)
      });
    });
  });
  describe('friendly captcha', function () {
    var wrapper;
    beforeAll(function () {
      var lockMock = createLockMock({
        provider: 'friendly_captcha',
        siteKey: 'mySiteKey'
      });
      var captcha = l.captcha(lockMock);
      wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_third_party_captcha.ThirdPartyCaptcha, {
        provider: captcha.get('provider'),
        sitekey: captcha.get('siteKey'),
        clientSubdomain: captcha.get('clientSubdomain'),
        hl: 'en',
        isValid: true,
        value: undefined
      })).instance();
      (0, _testUtils.act)(function () {
        var injectCaptchaScriptSpy = jest.spyOn(wrapper, 'injectCaptchaScript');
        wrapper.componentDidMount();
        jest.spyOn(global.window.friendlyChallenge, 'WidgetInstance');
        injectCaptchaScriptSpy.mock.calls[0][0]();
      });
    });
    it('should call WidgetInstance constructor with the correct renderParams', function () {
      var renderParams = global.window.friendlyChallenge.WidgetInstance.mock.calls[0][1];
      expect(renderParams).toEqual({
        sitekey: 'mySiteKey',
        doneCallback: expect.any(Function),
        errorCallback: expect.any(Function),
        language: 'en'
      });
    });
  });
  describe('hcaptcha', function () {
    var wrapper;
    beforeAll(function () {
      var lockMock = createLockMock({
        provider: 'hcaptcha',
        siteKey: 'mySiteKey'
      });
      var captcha = l.captcha(lockMock);
      wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_third_party_captcha.ThirdPartyCaptcha, {
        provider: captcha.get('provider'),
        sitekey: captcha.get('siteKey'),
        clientSubdomain: captcha.get('clientSubdomain'),
        hl: 'en',
        isValid: true,
        value: undefined
      })).instance();
      (0, _testUtils.act)(function () {
        var injectCaptchaScriptSpy = jest.spyOn(wrapper, 'injectCaptchaScript');
        wrapper.componentDidMount();
        injectCaptchaScriptSpy.mock.calls[0][0]();
      });
    });
    it('should call render with the correct renderParams', function () {
      var renderCalls = global.window.hcaptcha.render.mock.calls;
      var renderParams = renderCalls[0][1];
      expect(renderParams).toEqual({
        sitekey: 'mySiteKey',
        callback: expect.any(Function),
        'expired-callback': expect.any(Function),
        'error-callback': expect.any(Function)
      });
      expect(renderCalls.length).toEqual(1);
    });
    it('should call render on update', function () {
      (0, _testUtils.act)(function () {
        wrapper.setState();
        var renderCalls = global.window.hcaptcha.render.mock.calls;
        expect(renderCalls.length).toEqual(1);
      });
    });
  });
  describe('auth0_v2', function () {
    var wrapper;
    beforeAll(function () {
      var lockMock = createLockMock({
        provider: 'auth0_v2',
        siteKey: 'mySiteKey'
      });
      var captcha = l.captcha(lockMock);
      wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_third_party_captcha.ThirdPartyCaptcha, {
        provider: captcha.get('provider'),
        sitekey: captcha.get('siteKey'),
        clientSubdomain: captcha.get('clientSubdomain'),
        hl: 'en',
        isValid: true,
        value: undefined,
        onChange: jest.fn()
      })).instance();
      (0, _testUtils.act)(function () {
        var injectCaptchaScriptSpy = jest.spyOn(wrapper, 'injectCaptchaScript');
        wrapper.componentDidMount();
        injectCaptchaScriptSpy.mock.calls[0][0]();
      });
    });
    it('should call render with the correct renderParams', function () {
      var renderParams = global.window.turnstile.render.mock.calls[0][1];
      expect(renderParams).toEqual({
        sitekey: 'mySiteKey',
        callback: expect.any(Function),
        'expired-callback': expect.any(Function),
        'error-callback': expect.any(Function),
        language: 'en',
        theme: 'light',
        retry: 'never',
        'response-field': false
      });
    });
    it('should retry 3 times on error and then set value to BYPASS_CAPTCHA dummy token for failOpen', function () {
      var renderParams = global.window.turnstile.render.mock.calls[0][1];
      var _loop = function _loop() {
        var renderParams = global.window.turnstile.render.mock.calls[i][1];
        (0, _testUtils.act)(function () {
          renderParams['error-callback']();
        });
        var retryCount = wrapper.state.retryCount;
        var value = wrapper.props.value;
        expect(retryCount).toBe(i + 1);
        expect(value).toBe(undefined);
      };
      for (var i = 0; i < 3; i++) {
        _loop();
      }
      (0, _testUtils.act)(function () {
        return renderParams['error-callback']();
      });
      var onChange = wrapper.props.onChange;
      expect(onChange.mock.calls).toHaveLength(1);
      expect(onChange.mock.calls[0][0]).toBe('BYPASS_CAPTCHA');
    });
  });
  describe('recaptcha enterprise', function () {
    var wrapper;
    beforeAll(function () {
      var lockMock = createLockMock({
        provider: 'recaptcha_enterprise',
        siteKey: 'mySiteKey'
      });
      var captcha = l.captcha(lockMock);
      wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_third_party_captcha.ThirdPartyCaptcha, {
        provider: captcha.get('provider'),
        sitekey: captcha.get('siteKey'),
        clientSubdomain: captcha.get('clientSubdomain'),
        hl: 'en',
        isValid: true,
        value: undefined
      })).instance();
      (0, _testUtils.act)(function () {
        var injectCaptchaScriptSpy = jest.spyOn(wrapper, 'injectCaptchaScript');
        wrapper.componentDidMount();
        injectCaptchaScriptSpy.mock.calls[0][0]();
      });
    });
    it('should call render with the correct renderParams', function () {
      var renderParams = global.window.grecaptcha.enterprise.render.mock.calls[0][1];
      expect(renderParams).toEqual({
        sitekey: 'mySiteKey',
        callback: expect.any(Function),
        'expired-callback': expect.any(Function),
        'error-callback': expect.any(Function)
      });
    });
  });
});
