"use strict";

var _email = require("../../field/email");
describe('field/email', function () {
  describe('isEmail', function () {
    it('validates correctly', function () {
      expect((0, _email.isEmail)('test@test.com')).toBe(true);
      expect((0, _email.isEmail)('test@test.com.br')).toBe(true);
      expect((0, _email.isEmail)('test@移动.移动')).toBe(true);
      expect((0, _email.isEmail)('test@test.com ')).toBe(true);
      expect((0, _email.isEmail)(' test@test.com')).toBe(true);
      expect((0, _email.isEmail)(1)).toBe(false);
      expect((0, _email.isEmail)('test@testcom')).toBe(false);
      expect((0, _email.isEmail)('test.test.com')).toBe(false);
      expect((0, _email.isEmail)('test..@test.com')).toBe(true);
      expect((0, _email.isEmail)('test..@test.com', false)).toBe(true);
      expect((0, _email.isEmail)('test..@test.com', true)).toBe(false);
    });
    it('returns false when there is a white space in the middle of the string', function () {
      expect((0, _email.isEmail)('test@test. com')).toBe(false);
    });
  });
  describe('emailDomain', function () {
    it('extracts email domain correctly', function () {
      expect((0, _email.emailDomain)('test@test.com')).toBe('test.com');
      expect((0, _email.emailDomain)('test@test.com.br')).toBe('test.com.br');
      expect((0, _email.emailDomain)('test@移动.移动')).toBe('移动.移动');
      expect((0, _email.emailDomain)(1)).toBe('');
      expect((0, _email.emailDomain)('test@testcom')).toBe('');
      expect((0, _email.emailDomain)('test.test.com')).toBe('');
    });
  });
});
