"use strict";

var _immutable = _interopRequireDefault(require("immutable"));
var _field2 = require("../../field");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var createModel = function createModel(field) {
  return _immutable.default.fromJS({
    field: _defineProperty({}, field, "old_test_".concat(field))
  });
};
var testField = function testField(field, maxLength) {
  var m = createModel(field);
  expect((0, _field2.setField)(m, field, '').toJS().field[field].valid).toBe(false);
  expect((0, _field2.setField)(m, field, 'test_value').toJS().field[field].valid).toBe(true);
  if (maxLength) {
    expect((0, _field2.setField)(m, field, 'a'.repeat(maxLength + 1)).toJS().field[field].valid).toBe(false);
  }
};
describe('field/index', function () {
  describe('default validation', function () {
    it('validates family_name', function () {
      testField('family_name', 150);
    });
    it('validates family_name', function () {
      testField('given_name', 150);
    });
    it('validates name', function () {
      testField('name', 300);
    });
    it('validates nickname', function () {
      testField('nickname', 300);
    });
    it('validates other fields', function () {
      testField('test');
    });
  });
});
