"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setURL = exports.renderShallowComponent = exports.mockComponent = exports.extractPropsFromWrapper = exports.expectShallowComponent = exports.expectMockToMatch = exports.expectComponent = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactTestRenderer = _interopRequireDefault(require("react-test-renderer"));
var _shallow = _interopRequireDefault(require("react-test-renderer/shallow"));
var _webpack = require("webpack");
var _excluded = ["children"]; // eslint-disable-line
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } } return target; }
var expectComponent = exports.expectComponent = function expectComponent(children, opts) {
  var component = _reactTestRenderer.default.create(children, opts);
  return expect(component);
};
var expectShallowComponent = exports.expectShallowComponent = function expectShallowComponent(children) {
  var component = renderShallowComponent(children);
  return expect(component);
};
var renderShallowComponent = exports.renderShallowComponent = function renderShallowComponent(children) {
  var renderer = new _shallow.default();
  renderer.render(children);
  return renderer.getRenderOutput();
};
var addDataToProps = function addDataToProps(props) {
  var returnedProps = {};
  Object.keys(props).forEach(function (k) {
    return returnedProps["data-".concat(k)] = props[k];
  });
  return returnedProps;
};
var removeDataFromProps = function removeDataFromProps(props) {
  var returnedProps = {};
  Object.keys(props).forEach(function (k) {
    return returnedProps[k.replace('data-', '')] = props[k];
  });
  return returnedProps;
};
var mockComponent = exports.mockComponent = function mockComponent(type) {
  var domElement = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'div';
  return function (_ref) {
    var children = _ref.children,
      props = _objectWithoutProperties(_ref, _excluded);
    return /*#__PURE__*/_react.default.createElement(domElement, _objectSpread({
      'data-__type': type
    }, addDataToProps(props)), children);
  };
};
var extractPropsFromWrapper = exports.extractPropsFromWrapper = function extractPropsFromWrapper(wrapper) {
  var index = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
  return removeDataFromProps(wrapper.find('div').at(index).props());
};

// Newer (> Jest v22) versions don't allow modification of location.href
// but can use `jsdom.reconfigure` when `jsdom` is exposed globally.
// https://www.npmjs.com/package/jest-environment-jsdom-global
var setURL = exports.setURL = function setURL(url) {
  jsdom.reconfigure({
    url: url
  });
};
var expectMockToMatch = exports.expectMockToMatch = function expectMockToMatch(_ref2, numberOfCalls) {
  var mock = _ref2.mock;
  expect(mock.calls.length).toBe(numberOfCalls);
  for (var i = 0; i < numberOfCalls; i++) {
    expect(mock.calls[i]).toMatchSnapshot();
  }
};
