"use strict";

var _react = _interopRequireDefault(require("react"));
var _immutable = _interopRequireDefault(require("immutable"));
var _testUtils = require("../../testUtils");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
jest.mock('store/index', function () {
  return {
    swap: jest.fn(),
    updateEntity: 'updateEntity'
  };
});
jest.mock('ui/box/chrome', function () {
  return (0, _testUtils.mockComponent)('chrome');
});
var mockEvent = {
  preventDefault: function preventDefault() {}
};
var getContainer = function getContainer(opts) {
  var Container = require('ui/box/container').default;
  var props = Object.assign({}, {
    contentProps: {
      i18n: {},
      model: _immutable.default.fromJS({
        client: {
          connections: {
            database: [{
              name: 'dbA'
            }, {
              name: 'dbB'
            }]
          },
          id: 'alksdkhasd__test-lock__alsdkhalkshd'
        },
        field: {
          email: {
            invalidHint: null,
            showInvalid: false,
            valid: true,
            value: 'peter_picked@pickledpepper.com'
          }
        }
      })
    }
  }, opts);
  return new Container(props);
};
describe('Container', function () {
  it('does not call `connectionResolver` on submit when there is no custom `connectionResolver`', function () {
    var c = getContainer();
    c.handleSubmit(mockEvent);
    var mock = require('store/index').swap.mock;
    expect(mock.calls.length).toBe(0);
  });
  it('should submit the form when the form is not yet submitting', function () {
    var c = getContainer({
      isSubmitting: false
    });
    var connectionResolverMock = jest.fn();
    require('core/index').connectionResolver = function () {
      return connectionResolverMock;
    };
    c.handleSubmit(mockEvent);
    expect(connectionResolverMock).toHaveBeenCalled();
  });
  it('should not submit the form when the form is already submitting', function () {
    var c = getContainer({
      isSubmitting: true
    });
    var connectionResolverMock = jest.fn();
    require('core/index').connectionResolver = function () {
      return connectionResolverMock;
    };
    c.handleSubmit(mockEvent);
    expect(connectionResolverMock).not.toHaveBeenCalled();
  });
  describe('with a custom `connectionResolver`', function () {
    var connectionResolverMock;
    var setResolvedConnectionMock;
    beforeEach(function () {
      connectionResolverMock = jest.fn();
      setResolvedConnectionMock = jest.fn();
      require('core/index').connectionResolver = function () {
        return connectionResolverMock;
      };
      require('core/index').setResolvedConnection = setResolvedConnectionMock;
    });
    it('calls `connectionResolver` onSubmit', function () {
      var c = getContainer();
      c.handleSubmit(mockEvent);
      var _connectionResolverMo = connectionResolverMock,
        mock = _connectionResolverMo.mock;
      expect(mock.calls.length).toBe(1);
      expect(mock.calls[0]).toMatchSnapshot();
    });
    it('calls `swap` in the `connectionResolver` callback', function () {
      var c = getContainer();
      c.handleSubmit(mockEvent);
      connectionResolverMock.mock.calls[0][2]('resolvedConnection');
      var mock = require('store/index').swap.mock;
      expect(mock.calls.length).toBe(1);
      expect(mock.calls[0]).toMatchSnapshot();
    });
    it('calls `setResolvedConnection` in the `swap` callback', function () {
      var c = getContainer();
      c.handleSubmit(mockEvent);
      connectionResolverMock.mock.calls[0][2]('resolvedConnection');
      require('store/index').swap.mock.calls[0][3]('model');
      var _setResolvedConnectio = setResolvedConnectionMock,
        mock = _setResolvedConnectio.mock;
      expect(mock.calls.length).toBe(1);
      expect(mock.calls[0]).toMatchSnapshot();
    });
  });
  describe('when suppressSubmitOverlay is true', function () {
    it('it does not display the overlay when submitting', function () {
      var Container = require('ui/box/container').default;
      var props = {
        autoFocus: false,
        badgeLink: 'http://badge.link',
        contentComponent: null,
        contentProps: {},
        disableSubmitButton: false,
        isMobile: false,
        isModal: false,
        isSubmitting: true,
        logo: '',
        primaryColor: '',
        screenName: 'Test',
        showBadge: false,
        classNames: '',
        suppressSubmitOverlay: true
      };

      // Emitted snapshot should not add 'auth0-lock-mode-loading' class to the container div
      (0, _testUtils.expectComponent)( /*#__PURE__*/_react.default.createElement(Container, props)).toMatchSnapshot();
    });
  });
});
