"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _screen = _interopRequireDefault(require("../../core/screen"));
var _reset_password_pane = _interopRequireDefault(require("./reset_password_pane"));
var _index = require("./index");
var _actions = require("./actions");
var _password_reset_confirmation = require("./password_reset_confirmation");
var _index2 = require("../../connection/database/index");
var _enterprise = require("../../connection/enterprise");
var i18n = _interopRequireWildcard(require("../../i18n"));
var l = _interopRequireWildcard(require("../../core/index"));
var _index4 = require("../../store/index");
var _email = require("../../field/email");
var _field = require("../../field");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
var Component = /*#__PURE__*/function (_React$Component) {
  function Component() {
    _classCallCheck(this, Component);
    return _callSuper(this, Component, arguments);
  }
  _inherits(Component, _React$Component);
  return _createClass(Component, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var model = this.props.model;
      var connectionResolver = l.connectionResolver(model);

      // When using a custom connection resolver, `usernameStyle` is always 'username' (as opposed to 'email').
      // If the user has entered an email address as the username, and a custom resolver is being used, copy the
      // value from the 'username' field to the 'email' field so that `EmailPane` can render it.
      if (connectionResolver) {
        var field = (0, _field.getField)(model, 'username');
        var value = field.get('value', '');
        (0, _index4.swap)(_index4.updateEntity, 'lock', l.id(model), _email.setEmail, (0, _email.isEmail)(value, false) ? value : '', false);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
        i18n = _this$props.i18n,
        model = _this$props.model;
      var headerText = i18n.html('forgotPasswordInstructions') || null;
      var header = headerText && /*#__PURE__*/_react.default.createElement("p", null, headerText);
      return /*#__PURE__*/_react.default.createElement(_reset_password_pane.default, {
        emailInputPlaceholder: i18n.str('emailInputPlaceholder'),
        header: header,
        i18n: i18n,
        lock: model
      });
    }
  }]);
}(_react.default.Component);
var ResetPassword = exports.default = /*#__PURE__*/function (_Screen) {
  function ResetPassword() {
    _classCallCheck(this, ResetPassword);
    return _callSuper(this, ResetPassword, ['forgotPassword']);
  }
  _inherits(ResetPassword, _Screen);
  return _createClass(ResetPassword, [{
    key: "backHandler",
    value: function backHandler(m) {
      return (0, _index.hasScreen)(m, 'login') ? _actions.cancelResetPassword : undefined;
    }
  }, {
    key: "submitButtonLabel",
    value: function submitButtonLabel(m) {
      return i18n.str(m, ['forgotPasswordSubmitLabel']);
    }
  }, {
    key: "getScreenTitle",
    value: function getScreenTitle(m) {
      return i18n.str(m, 'forgotPasswordTitle');
    }
  }, {
    key: "isSubmitDisabled",
    value: function isSubmitDisabled(m) {
      var tryingToResetPasswordWithEnterpriseEmail = (0, _enterprise.isEnterpriseDomain)(m, (0, _index2.databaseUsernameValue)(m, {
        emailFirst: true
      }));
      if (tryingToResetPasswordWithEnterpriseEmail) {
        setTimeout(function () {
          (0, _index4.swap)(_index4.updateEntity, 'lock', l.id(m), l.setGlobalError, i18n.str(m, ['error', 'forgotPassword', 'enterprise_email']));
        }, 50);
      } else {
        (0, _index4.swap)(_index4.updateEntity, 'lock', l.id(m), l.clearGlobalError);
      }
      return tryingToResetPasswordWithEnterpriseEmail;
    }
  }, {
    key: "submitHandler",
    value: function submitHandler() {
      return _actions.resetPassword;
    }
  }, {
    key: "renderAuxiliaryPane",
    value: function renderAuxiliaryPane(m) {
      return (0, _password_reset_confirmation.renderPasswordResetConfirmation)(m);
    }
  }, {
    key: "render",
    value: function render() {
      return Component;
    }
  }]);
}(_screen.default);
