"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var l = _interopRequireWildcard(require("./index"));
var i18n = _interopRequireWildcard(require("../i18n"));
var _index2 = require("../connection/database/index");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var Screen = exports.default = /*#__PURE__*/function () {
  function Screen(name) {
    _classCallCheck(this, Screen);
    this.name = name;
  }
  return _createClass(Screen, [{
    key: "backHandler",
    value: function backHandler() {
      return null;
    }
  }, {
    key: "escHandler",
    value: function escHandler() {
      return null;
    }
  }, {
    key: "submitButtonLabel",
    value: function submitButtonLabel(m) {
      return i18n.str(m, ['submitLabel']);
    }
  }, {
    key: "isFirstScreen",
    value: function isFirstScreen(m) {
      var firstScreenName = (0, _index2.getInitialScreen)(m);
      var currentScreenNameParts = this.name.split('.');
      var currentScreenName = currentScreenNameParts[1] || currentScreenNameParts[0];

      // if signup and login is enabled, both are the first screen in this scenario and
      // neither of them should show the title
      if (currentScreenName === 'signUp' && (0, _index2.hasScreen)(m, 'login')) {
        return true;
      }
      var initialScreens = [firstScreenName, 'loading', 'lastLogin'];
      return initialScreens.indexOf(currentScreenName) !== -1;
    }
  }, {
    key: "getTitle",
    value: function getTitle(m) {
      //loading screen will never show a title
      if (this.name === 'loading') {
        return '';
      }
      return this.getScreenTitle(m) || i18n.str(m, 'title');
    }
  }, {
    key: "getScreenTitle",
    value: function getScreenTitle(m) {
      return i18n.str(m, 'title');
    }
  }, {
    key: "submitHandler",
    value: function submitHandler() {
      return null;
    }
  }, {
    key: "isSubmitDisabled",
    value: function isSubmitDisabled(m) {
      return false;
    }
  }, {
    key: "renderAuxiliaryPane",
    value: function renderAuxiliaryPane() {
      return null;
    }
  }, {
    key: "renderTabs",
    value: function renderTabs() {
      return false;
    }
  }, {
    key: "renderTerms",
    value: function renderTerms() {
      return null;
    }
  }]);
}();
