"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _auth0Js = _interopRequireDefault(require("auth0-js"));
var _qs = _interopRequireDefault(require("qs"));
var _cordovaAuth0PluginMin = _interopRequireDefault(require("auth0-js/dist/cordova-auth0-plugin.min.js"));
var _helper = require("./helper");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var Auth0APIClient = /*#__PURE__*/function () {
  function Auth0APIClient(lockID, clientID, domain, opts) {
    _classCallCheck(this, Auth0APIClient);
    this.lockID = lockID;
    this.client = null;
    this.authOpt = null;
    this.domain = domain;
    this.isUniversalLogin = window.location.host === domain;
    this._enableIdPInitiatedLogin = !!(opts._enableIdPInitiatedLogin || opts._enableImpersonation);
    var telemetry = this.getTelemetryInfo(opts._telemetryInfo);
    var state = opts.state;
    if (opts.params && opts.params.state) {
      state = opts.params.state;
    }
    var nonce = opts.nonce;
    if (opts.params && opts.params.nonce) {
      nonce = opts.params.nonce;
    }
    var scope = opts.params && opts.params.scope;
    this.client = new _auth0Js.default.WebAuth({
      clientID: clientID,
      domain: domain,
      audience: opts.audience,
      redirectUri: opts.redirectUrl,
      responseMode: opts.responseMode,
      responseType: opts.responseType,
      leeway: opts.leeway || 60,
      plugins: opts.plugins || [new _cordovaAuth0PluginMin.default()],
      overrides: (0, _helper.webAuthOverrides)(opts.overrides),
      _sendTelemetry: opts._sendTelemetry === false ? false : true,
      _telemetryInfo: telemetry,
      state: state,
      nonce: nonce,
      scope: scope,
      legacySameSiteCookie: opts.legacySameSiteCookie
    });
    this.authOpt = {
      popup: !opts.redirect,
      popupOptions: opts.popupOptions,
      nonce: nonce,
      state: state,
      scope: scope
    };
    if (this.isUniversalLogin && opts.sso !== undefined) {
      this.authOpt.sso = opts.sso;
    }
  }
  return _createClass(Auth0APIClient, [{
    key: "getTelemetryInfo",
    value: function getTelemetryInfo(telemetryOverride) {
      var telemetry;
      var _qs$parse = _qs.default.parse(window.location.search.substr(1)),
        auth0Client = _qs$parse.auth0Client;
      var ulpTelemetry = auth0Client && JSON.parse(atob(auth0Client));
      if (this.isUniversalLogin && ulpTelemetry) {
        telemetry = _objectSpread(_objectSpread({}, ulpTelemetry), {}, {
          env: _objectSpread(_objectSpread({}, ulpTelemetry.env), {}, _defineProperty(_defineProperty({}, 'lock.js-ulp', (0, _helper.getVersion)()), 'auth0.js-ulp', _auth0Js.default.version.raw))
        });
      }
      if (this.isUniversalLogin && !ulpTelemetry) {
        telemetry = {
          name: 'lock.js-ulp',
          version: (0, _helper.getVersion)(),
          env: _defineProperty({}, 'auth0.js-ulp', _auth0Js.default.version.raw)
        };
      }
      if (!this.isUniversalLogin && telemetryOverride) {
        telemetry = _objectSpread(_objectSpread({}, telemetryOverride), {}, {
          env: _objectSpread(_objectSpread({}, telemetryOverride.env), {}, _defineProperty(_defineProperty({}, 'lock.js', (0, _helper.getVersion)()), 'auth0.js', _auth0Js.default.version.raw))
        });
      }
      if (!telemetry) {
        telemetry = {
          name: 'lock.js',
          version: (0, _helper.getVersion)(),
          env: _defineProperty({}, 'auth0.js', _auth0Js.default.version.raw)
        };
      }
      return telemetry;
    }
  }, {
    key: "logIn",
    value: function logIn(options, authParams, cb) {
      // TODO: for passwordless only, try to clean in auth0.js
      // client._shouldRedirect = redirect || responseType === "code" || !!redirectUrl;
      var f = (0, _helper.loginCallback)(false, this.domain, cb);
      var loginOptions = (0, _helper.trimAuthParams)((0, _helper.normalizeAuthParams)(_objectSpread(_objectSpread(_objectSpread({}, options), this.authOpt), authParams)));
      if (options.login_hint) {
        loginOptions.login_hint = options.login_hint;
      }
      if (!options.username && !options.email) {
        if (this.authOpt.popup) {
          this.client.popup.authorize(_objectSpread(_objectSpread({}, loginOptions), {}, {
            owp: true
          }), f);
        } else {
          this.client.authorize(loginOptions, f);
        }
      } else if (this.authOpt.popup) {
        this.client.popup.loginWithCredentials(loginOptions, f);
      } else {
        loginOptions.realm = options.connection;
        this.client.login(loginOptions, f);
      }
    }
  }, {
    key: "logout",
    value: function logout(query) {
      this.client.logout(query);
    }
  }, {
    key: "signUp",
    value: function signUp(options, cb) {
      delete options.autoLogin;
      this.client.signup((0, _helper.trimAuthParams)(options), function (err, result) {
        return cb(err, result);
      });
    }
  }, {
    key: "resetPassword",
    value: function resetPassword(options, cb) {
      this.client.changePassword((0, _helper.trimAuthParams)(options), cb);
    }
  }, {
    key: "passwordlessStart",
    value: function passwordlessStart(options, cb) {
      this.client.passwordlessStart((0, _helper.trimAuthParams)(options), function (err) {
        return cb((0, _helper.normalizeError)(err));
      });
    }
  }, {
    key: "passwordlessVerify",
    value: function passwordlessVerify(options, cb) {
      var verifyOptions = _objectSpread(_objectSpread({}, options), {}, {
        popup: this.authOpt.popup
      });
      this.client.passwordlessLogin(verifyOptions, function (err, result) {
        return cb((0, _helper.normalizeError)(err), result);
      });
    }
  }, {
    key: "parseHash",
    value: function parseHash() {
      var hash = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
      var cb = arguments.length > 1 ? arguments[1] : undefined;
      return this.client.parseHash({
        __enableIdPInitiatedLogin: this._enableIdPInitiatedLogin,
        hash: hash,
        nonce: this.authOpt.nonce,
        state: this.authOpt.state
      }, cb);
    }
  }, {
    key: "getUserInfo",
    value: function getUserInfo(token, callback) {
      return this.client.client.userInfo(token, callback);
    }
  }, {
    key: "getProfile",
    value: function getProfile(token, callback) {
      this.getUserInfo(token, callback);
    }
  }, {
    key: "getSSOData",
    value: function getSSOData() {
      var _this$client$client;
      return (_this$client$client = this.client.client).getSSOData.apply(_this$client$client, arguments);
    }
  }, {
    key: "getChallenge",
    value: function getChallenge() {
      var _this$client$client2;
      return (_this$client$client2 = this.client.client).getChallenge.apply(_this$client$client2, arguments);
    }
  }, {
    key: "getPasswordlessChallenge",
    value: function getPasswordlessChallenge() {
      var _this$client$client$p;
      return (_this$client$client$p = this.client.client.passwordless).getChallenge.apply(_this$client$client$p, arguments);
    }
  }, {
    key: "getPasswordResetChallenge",
    value: function getPasswordResetChallenge() {
      var _this$client$client$d;
      return (_this$client$client$d = this.client.client.dbConnection).getPasswordResetChallenge.apply(_this$client$client$d, arguments);
    }
  }, {
    key: "getUserCountry",
    value: function getUserCountry(cb) {
      return this.client.client.getUserCountry(cb);
    }
  }, {
    key: "checkSession",
    value: function checkSession(options, cb) {
      return this.client.checkSession(options, cb);
    }
  }]);
}();
var _default = exports.default = Auth0APIClient;
