"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _screen = _interopRequireDefault(require("../../core/screen"));
var _actions = require("../../connection/passwordless/actions");
var _phone_number_pane = _interopRequireDefault(require("../../field/phone-number/phone_number_pane"));
var _social_buttons_pane = _interopRequireDefault(require("../../field/social/social_buttons_pane"));
var _captcha_pane = _interopRequireDefault(require("../../field/captcha/captcha_pane"));
var _captcha = require("../../connection/captcha");
var _signed_in_confirmation = require("../../core/signed_in_confirmation");
var _pane_separator = _interopRequireDefault(require("../../core/pane_separator"));
var l = _interopRequireWildcard(require("../../core/index"));
var _index2 = require("../../field/index");
var _index3 = require("../../connection/passwordless/index");
var _sign_up_terms = _interopRequireDefault(require("../../connection/database/sign_up_terms"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
var Component = function Component(_ref) {
  var i18n = _ref.i18n,
    model = _ref.model;
  var social = l.hasSomeConnections(model, 'social') ? /*#__PURE__*/_react.default.createElement(_social_buttons_pane.default, {
    instructions: i18n.html('socialLoginInstructions'),
    labelFn: i18n.str,
    lock: model,
    signUp: true
  }) : null;
  var phoneNumberInstructionsI18nKey = social ? 'passwordlessSMSAlternativeInstructions' : 'passwordlessSMSInstructions';
  var phoneNumber = l.hasSomeConnections(model, 'passwordless', 'sms') ? /*#__PURE__*/_react.default.createElement(_phone_number_pane.default, {
    instructions: i18n.html(phoneNumberInstructionsI18nKey),
    lock: model,
    placeholder: i18n.str('phoneNumberInputPlaceholder'),
    invalidHint: i18n.str('phoneNumberInputInvalidHint')
  }) : null;
  var captchaPane = l.passwordlessCaptcha(model) && l.passwordlessCaptcha(model).get('required') ? /*#__PURE__*/_react.default.createElement(_captcha_pane.default, {
    i18n: i18n,
    lock: model,
    flow: _captcha.Flow.PASSWORDLESS,
    onReload: function onReload() {
      return (0, _captcha.swapCaptcha)(l.id(model), _captcha.Flow.PASSWORDLESS, false);
    }
  }) : null;
  var separator = social && phoneNumber ? /*#__PURE__*/_react.default.createElement(_pane_separator.default, null) : null;
  return /*#__PURE__*/_react.default.createElement("div", null, social, separator, phoneNumber, captchaPane);
};
var AskSocialNetworkOrPhoneNumber = exports.default = /*#__PURE__*/function (_Screen) {
  function AskSocialNetworkOrPhoneNumber() {
    _classCallCheck(this, AskSocialNetworkOrPhoneNumber);
    return _callSuper(this, AskSocialNetworkOrPhoneNumber, ['socialOrPhoneNumber']);
  }
  _inherits(AskSocialNetworkOrPhoneNumber, _Screen);
  return _createClass(AskSocialNetworkOrPhoneNumber, [{
    key: "submitHandler",
    value: function submitHandler(m) {
      return l.hasSomeConnections(m, 'passwordless', 'sms') ? _actions.sendSMS : null;
    }
  }, {
    key: "renderAuxiliaryPane",
    value: function renderAuxiliaryPane(lock) {
      return (0, _signed_in_confirmation.renderSignedInConfirmation)(lock) || (0, _index2.renderOptionSelection)(lock);
    }
  }, {
    key: "render",
    value: function render() {
      return Component;
    }
  }, {
    key: "isSubmitDisabled",
    value: function isSubmitDisabled(m) {
      return !(0, _index3.termsAccepted)(m);
    }
  }, {
    key: "renderTerms",
    value: function renderTerms(m, terms) {
      var checkHandler = (0, _index3.mustAcceptTerms)(m) ? function () {
        return (0, _actions.toggleTermsAcceptance)(l.id(m));
      } : undefined;
      return terms && (0, _index3.showTerms)(m) ? /*#__PURE__*/_react.default.createElement(_sign_up_terms.default, {
        showCheckbox: (0, _index3.mustAcceptTerms)(m),
        checkHandler: checkHandler,
        checked: (0, _index3.termsAccepted)(m)
      }, terms) : null;
    }
  }]);
}(_screen.default);
