"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _actions = require("./actions");
var _index = require("./index");
var _text_input = _interopRequireDefault(require("../ui/input/text_input"));
var _select_input = _interopRequireDefault(require("../ui/input/select_input"));
var _checkbox_input = _interopRequireDefault(require("../ui/input/checkbox_input"));
var l = _interopRequireWildcard(require("../core/index"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
var CustomInput = function CustomInput(_ref) {
  var iconUrl = _ref.iconUrl,
    model = _ref.model,
    name = _ref.name,
    ariaLabel = _ref.ariaLabel,
    placeholder = _ref.placeholder,
    placeholderHTML = _ref.placeholderHTML,
    type = _ref.type,
    validator = _ref.validator,
    value = _ref.value;
  var props = {
    iconUrl: iconUrl,
    isValid: !(0, _index.isFieldVisiblyInvalid)(model, name),
    name: name,
    ariaLabel: ariaLabel,
    placeholder: placeholder
  };
  switch (type) {
    case 'select':
      return /*#__PURE__*/_react.default.createElement(_select_input.default, _extends({}, props, {
        lockId: l.id(model),
        label: (0, _index.getFieldLabel)(model, name),
        onClick: function onClick() {
          return (0, _actions.startOptionSelection)(l.id(model), name, iconUrl);
        }
      }));
    case 'checkbox':
      return /*#__PURE__*/_react.default.createElement(_checkbox_input.default, _extends({
        lockId: l.id(model),
        invalidHint: (0, _index.getFieldInvalidHint)(model, name),
        onChange: function onChange(e) {
          return (0, _actions.changeField)(l.id(model), name, "".concat(e.target.checked), validator);
        },
        checked: (0, _index.getFieldValue)(model, name),
        placeholderHTML: placeholderHTML
      }, props));
    case 'hidden':
      return /*#__PURE__*/_react.default.createElement("input", {
        id: l.id(model),
        type: "hidden",
        value: value,
        name: name
      });
    default:
      return /*#__PURE__*/_react.default.createElement(_text_input.default, _extends({
        lockId: l.id(model),
        invalidHint: (0, _index.getFieldInvalidHint)(model, name),
        onChange: function onChange(e) {
          return (0, _actions.changeField)(l.id(model), name, e.target.value, validator);
        },
        value: (0, _index.getFieldValue)(model, name)
      }, props));
  }
};
var _default = exports.default = CustomInput;
