"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _email_input = _interopRequireDefault(require("../../ui/input/email_input"));
var c = _interopRequireWildcard(require("../index"));
var _index2 = require("../../store/index");
var l = _interopRequireWildcard(require("../../core/index"));
var _email = require("../email");
var _avatar = require("../../avatar");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
var EmailPane = exports.default = /*#__PURE__*/function (_React$Component) {
  function EmailPane() {
    _classCallCheck(this, EmailPane);
    return _callSuper(this, EmailPane, arguments);
  }
  _inherits(EmailPane, _React$Component);
  return _createClass(EmailPane, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this$props = this.props,
        lock = _this$props.lock,
        strictValidation = _this$props.strictValidation;
      if (l.ui.avatar(lock) && c.email(lock)) {
        (0, _avatar.requestAvatar)(l.id(lock), c.email(lock));
      }
      (0, _index2.swap)(_index2.updateEntity, 'lock', l.id(lock), _email.setEmail, c.email(lock), strictValidation);
    }
  }, {
    key: "handleChange",
    value: function handleChange(e) {
      var _this$props2 = this.props,
        lock = _this$props2.lock,
        strictValidation = _this$props2.strictValidation;
      if (l.ui.avatar(lock)) {
        (0, _avatar.debouncedRequestAvatar)(l.id(lock), e.target.value);
      }
      (0, _index2.swap)(_index2.updateEntity, 'lock', l.id(lock), _email.setEmail, e.target.value, strictValidation);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props3 = this.props,
        i18n = _this$props3.i18n,
        lock = _this$props3.lock,
        placeholder = _this$props3.placeholder,
        _this$props3$forceInv = _this$props3.forceInvalidVisibility,
        forceInvalidVisibility = _this$props3$forceInv === void 0 ? false : _this$props3$forceInv;
      var allowAutocomplete = l.ui.allowAutocomplete(lock);
      var field = c.getField(lock, 'email');
      var value = field.get('value', '');
      var valid = field.get('valid', true);

      // TODO: invalidErrorHint and blankErrorHint are deprecated.
      // They are kept for backwards compatibility in the code for the customers overwriting
      // them with languageDictionary. They can be removed in the next major release.
      var errMessage = value ? i18n.str('invalidErrorHint') || i18n.str('invalidEmailErrorHint') : i18n.str('blankErrorHint') || i18n.str('blankEmailErrorHint');
      var invalidHint = field.get('invalidHint') || errMessage;
      var isValid = (!forceInvalidVisibility || valid) && !c.isFieldVisiblyInvalid(lock, 'email');
      // Hide the error message for the blank email in Enterprise HRD only mode when the password field is hidden.
      isValid = forceInvalidVisibility && value === '' ? true : isValid;
      return /*#__PURE__*/_react.default.createElement(_email_input.default, {
        lockId: l.id(lock),
        value: value,
        invalidHint: invalidHint,
        isValid: isValid,
        onChange: this.handleChange.bind(this),
        placeholder: placeholder,
        autoComplete: allowAutocomplete,
        disabled: l.submitting(lock)
      });
    }
  }]);
}(_react.default.Component);
EmailPane.propTypes = {
  i18n: _propTypes.default.object.isRequired,
  lock: _propTypes.default.object.isRequired,
  placeholder: _propTypes.default.string.isRequired,
  strictValidation: _propTypes.default.bool.isRequired
};
