"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.clearFields = clearFields;
exports.email = email;
exports.getField = getField;
exports.getFieldInvalidHint = getFieldInvalidHint;
exports.getFieldLabel = getFieldLabel;
exports.getFieldValue = getFieldValue;
exports.hideInvalidFields = hideInvalidFields;
exports.isFieldValid = isFieldValid;
exports.isFieldVisiblyInvalid = isFieldVisiblyInvalid;
exports.isSelecting = isSelecting;
exports.mfaCode = mfaCode;
exports.password = password;
exports.phoneNumber = phoneNumber;
exports.registerOptionField = registerOptionField;
exports.renderOptionSelection = renderOptionSelection;
exports.setField = setField;
exports.setFieldShowInvalid = setFieldShowInvalid;
exports.setOptionField = setOptionField;
exports.showInvalidField = showInvalidField;
exports.username = username;
exports.vcode = vcode;
var _react = _interopRequireDefault(require("react"));
var _immutable = require("immutable");
var _trim = _interopRequireDefault(require("trim"));
var _option_selection_pane = _interopRequireDefault(require("./option_selection_pane"));
var l = _interopRequireWildcard(require("../core/index"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var minMax = function minMax(value, min, max) {
  return value.length >= min && value.length <= max;
};
var getDefaultValidator = function getDefaultValidator(field) {
  switch (field) {
    case 'family_name':
    case 'given_name':
      return function (str) {
        return minMax((0, _trim.default)(str), 1, 150);
      };
    case 'name':
      return function (str) {
        return minMax((0, _trim.default)(str), 1, 300);
      };
    case 'nickname':
      return function (str) {
        return minMax((0, _trim.default)(str), 1, 300);
      };
    default:
      return function (str) {
        return (0, _trim.default)(str).length > 0;
      };
  }
};
function setField(m, field, value) {
  var validator = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : getDefaultValidator(field);
  var prevValue = m.getIn(['field', field, 'value']);
  var prevShowInvalid = m.getIn(['field', field, 'showInvalid'], false);
  for (var _len = arguments.length, args = new Array(_len > 4 ? _len - 4 : 0), _key = 4; _key < _len; _key++) {
    args[_key - 4] = arguments[_key];
  }
  var validation = validate.apply(void 0, [validator, value].concat(args));
  return m.mergeIn(['field', field], validation.merge({
    value: value,
    showInvalid: prevShowInvalid && prevValue === value
  }));
}
function validate(validator, value) {
  if (typeof validator != 'function') return (0, _immutable.Map)({
    valid: true
  });
  for (var _len2 = arguments.length, args = new Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {
    args[_key2 - 2] = arguments[_key2];
  }
  var validation = validator.apply(void 0, [value].concat(args));
  return validation && _typeof(validation) === 'object' ? (0, _immutable.Map)({
    valid: validation.valid,
    invalidHint: validation.hint
  }) : (0, _immutable.Map)({
    valid: !!validation
  });
}

// TODO: this should handle icons, and everything.
// TODO: also there should be a similar fn for regular fields.
function registerOptionField(m, field, options, initialValue) {
  var valid = true,
    hasInitial = !initialValue,
    initialOption;
  options.forEach(function (x) {
    valid = valid && x.get('label') && typeof x.get('label') === 'string' && x.get('value') && typeof x.get('value') === 'string';
    if (!hasInitial && x.get('value') === initialValue) {
      initialOption = x;
      hasInitial = true;
    }
  });
  if (!valid || !options.size) {
    var stopError = new Error("The options provided for the \"".concat(field, "\" field are invalid, they must have the following format: {label: \"non-empty string\", value: \"non-empty string\"} and there has to be at least one option."));
    stopError.code = 'invalid_select_field';
    // TODO: in the future we might want to return the result of the
    // operation along with the model instead of stopping the
    // rendering, like [false, m] in the case of failure and [true, m]
    // in the case of success.
    return l.stop(m, stopError);
  }
  if (!initialOption) initialOption = (0, _immutable.Map)({});
  return m.mergeIn(['field', field], initialOption, (0, _immutable.Map)({
    options: options,
    showInvalid: false,
    valid: !initialOption.isEmpty()
  }));
}
function setOptionField(m, field, option) {
  return m.mergeIn(['field', field], option.merge((0, _immutable.Map)({
    valid: true,
    showInvalid: false
  })));
}
function isFieldValid(m, field) {
  return m.getIn(['field', field, 'valid']);
}
function getFieldInvalidHint(m, field) {
  return m.getIn(['field', field, 'invalidHint'], '');
}
function isFieldVisiblyInvalid(m, field) {
  return m.getIn(['field', field, 'showInvalid'], false) && !m.getIn(['field', field, 'valid']);
}
function showInvalidField(m, field) {
  return m.setIn(['field', field, 'showInvalid'], !isFieldValid(m, field));
}
function hideInvalidFields(m) {
  return m.update('field', function (fields) {
    return fields && fields.map(function (field) {
      return field.set('showInvalid', false);
    });
  });
}

// TODO: only used in passwordless, when we update it to use
// validateAndSubmit this won't be needed anymore.
function setFieldShowInvalid(m, field, value) {
  return m.setIn(['field', field, 'showInvalid'], value);
}
function clearFields(m, fields) {
  var keyPaths;
  if (!fields || fields.length === 0) {
    keyPaths = [['field']];
  } else {
    keyPaths = fields.map(function (x) {
      return ['field', x];
    });
  }
  return keyPaths.reduce(function (r, v) {
    return r.removeIn(v);
  }, m);
}
function getField(m, field) {
  var notFound = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : new _immutable.Map({});
  return m.getIn(['field', field], notFound);
}
function getFieldValue(m, field) {
  var notFound = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
  return getField(m, field).get('value', notFound);
}
function getFieldLabel(m, field) {
  var notFound = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
  return getField(m, field).get('label', notFound);
}

// phone number

function phoneNumber(lock) {
  return lock.getIn(['field', 'phoneNumber', 'value'], '');
}

// email

function email(m) {
  return getFieldValue(m, 'email');
}

// vcode

function vcode(m) {
  return getFieldValue(m, 'vcode');
}

// password

function password(m) {
  return getFieldValue(m, 'password');
}

// username

function username(m) {
  return getFieldValue(m, 'username');
}

// mfa_code

function mfaCode(m) {
  return getFieldValue(m, 'mfa_code');
}

// select field options

function isSelecting(m) {
  return !!m.getIn(['field', 'selecting']);
}
function renderOptionSelection(m) {
  var name = m.getIn(['field', 'selecting', 'name']);
  return isSelecting(m) ? /*#__PURE__*/_react.default.createElement(_option_selection_pane.default, {
    model: m,
    name: name,
    icon: m.getIn(['field', 'selecting', 'icon']),
    iconUrl: m.getIn(['field', 'selecting', 'iconUrl']),
    items: m.getIn(['field', name, 'options'])
  }) : null;
}
