"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.render = exports.remove = void 0;
var _react = _interopRequireDefault(require("react"));
var _client = require("react-dom/client");
var _CSSCore = _interopRequireDefault(require("../CSSCore"));
var _container = _interopRequireDefault(require("./box/container"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var ContainerManager = /*#__PURE__*/function () {
  function ContainerManager() {
    _classCallCheck(this, ContainerManager);
  }
  return _createClass(ContainerManager, [{
    key: "ensure",
    value: function ensure(id, shouldAppend) {
      var container = window.document.getElementById(id);
      if (!container && shouldAppend) {
        container = window.document.createElement('main');
        container.id = id;
        container.className = 'auth0-lock-container';
        window.document.body.appendChild(container);
      }
      if (!container) {
        throw new Error("Can't find element with id ".concat(id));
      }
      return container;
    }
  }]);
}();
var Renderer = /*#__PURE__*/function () {
  function Renderer() {
    _classCallCheck(this, Renderer);
    this.containerManager = new ContainerManager();
    this.modals = {};
  }
  return _createClass(Renderer, [{
    key: "render",
    value: function render(containerId, props) {
      var _this = this;
      var isModal = props.isModal;
      var container = this.containerManager.ensure(containerId, isModal);
      if (isModal && !this.modals[containerId]) {
        _CSSCore.default.addClass(window.document.getElementsByTagName('html')[0], 'auth0-lock-html');
      }
      // eslint-disable-next-line
      var root = this.modals[containerId] ? this.modals[containerId].root : (0, _client.createRoot)(container);
      if (!this.modals[containerId]) {
        this.modals[containerId] = {
          root: root
        };
      }
      root.render( /*#__PURE__*/_react.default.createElement(_container.default, _extends({}, props, {
        ref: function ref(component) {
          if (component && isModal) {
            _this.modals[containerId].component = component;
          }
        }
      })));
    }
  }, {
    key: "remove",
    value: function remove(containerId) {
      var _this2 = this;
      if (this.modals[containerId] && this.modals[containerId].component) {
        this.modals[containerId].component.hide();
        setTimeout(function () {
          return _this2.unmount(containerId);
        }, 1000);
      } else {
        this.unmount(containerId);
      }
    }
  }, {
    key: "unmount",
    value: function unmount(containerId) {
      try {
        var container = this.containerManager.ensure(containerId);
        if (container) {
          ReactDOM.unmountComponentAtNode(container);
        }
      } catch (e) {
        // do nothing if container doesn't exist
      }
      if (this.modals[containerId]) {
        this.modals[containerId].root.unmount();
        delete this.modals[containerId];
        _CSSCore.default.removeClass(window.document.getElementsByTagName('html')[0], 'auth0-lock-html');
      }
    }
  }]);
}();
var renderer = new Renderer();
var render = exports.render = function render() {
  return renderer.render.apply(renderer, arguments);
};
var remove = exports.remove = function remove() {
  return renderer.remove.apply(renderer, arguments);
};
