"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _button = require("./box/button");
var _text_input = _interopRequireDefault(require("./input/text_input"));
var _media_utils = require("../utils/media_utils");
var su = _interopRequireWildcard(require("../utils/string_utils"));
var l = _interopRequireWildcard(require("../core/index"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
var cycle = function cycle(xs, x) {
  return xs.skipWhile(function (y) {
    return y !== x;
  }).get(1, xs.get(0));
};
var FiltrableList = exports.default = /*#__PURE__*/function (_React$Component) {
  function FiltrableList(props) {
    var _this;
    _classCallCheck(this, FiltrableList);
    _this = _callSuper(this, FiltrableList, [props]);
    _this.state = {
      filteredItems: props.items,
      highlighted: props.defaultItem
    };
    return _this;
  }
  _inherits(FiltrableList, _React$Component);
  return _createClass(FiltrableList, [{
    key: "filter",
    value: function filter(str) {
      var filteredItems = this.props.items.filter(function (x) {
        return su.matches(str, x.get('label'));
      });
      var highlighted = filteredItems.size === 1 && filteredItems.get(0) || filteredItems.includes(this.state.highlighted) && this.state.highlighted || null;
      return {
        filteredItems: filteredItems,
        highlighted: highlighted
      };
    }
  }, {
    key: "select",
    value: function select(x) {
      this.props.onSelect(x);
    }
  }, {
    key: "handleChange",
    value: function handleChange(e) {
      this.setState(this.filter(e.target.value));
    }
  }, {
    key: "handleKeyDown",
    value: function handleKeyDown(e) {
      var _this$state = this.state,
        filteredItems = _this$state.filteredItems,
        highlighted = _this$state.highlighted;
      switch (e.key) {
        case 'ArrowDown':
          e.preventDefault();
          this.setState({
            highlighted: cycle(filteredItems, highlighted)
          });
          break;
        case 'ArrowUp':
          e.preventDefault();
          this.setState({
            highlighted: cycle(filteredItems.reverse(), highlighted)
          });
          break;
        case 'Enter':
          e.preventDefault();
          highlighted && this.select(highlighted);
          break;
        case 'Escape':
          e.preventDefault();
          this.props.onCancel();
        default:
        // no-op
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props = this.props,
        icon = _this$props.icon,
        iconUrl = _this$props.iconUrl,
        onCancel = _this$props.onCancel,
        model = _this$props.model;
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "auth0-lock-select-country"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "auth0-lock-search"
      }, /*#__PURE__*/_react.default.createElement(_button.BackButton, {
        lockId: l.id(model),
        onClick: onCancel
      }), /*#__PURE__*/_react.default.createElement(_text_input.default, {
        lockId: l.id(model),
        name: "search",
        icon: icon,
        iconUrl: iconUrl,
        isValid: true,
        onChange: this.handleChange.bind(this),
        onKeyDown: this.handleKeyDown.bind(this)
      })), /*#__PURE__*/_react.default.createElement(List, {
        highlighted: this.state.highlighted,
        items: this.state.filteredItems,
        onClick: this.select.bind(this),
        onMouseMove: function onMouseMove(x) {
          return _this2.setState({
            highlighted: x
          });
        }
      }));
    }
  }]);
}(_react.default.Component);
var List = /*#__PURE__*/function (_React$Component2) {
  function List() {
    _classCallCheck(this, List);
    return _callSuper(this, List, arguments);
  }
  _inherits(List, _React$Component2);
  return _createClass(List, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      var _this3 = this;
      // Ensure that highlighted item is entirely visible

      // NOTE: I've spent very little time on this. It works, but it
      // surely can be more clearly.

      var highlighted = this.refs.highlighted;
      if (highlighted) {
        var scrollableNode = _reactDom.default.findDOMNode(this);
        var highlightedNode = _reactDom.default.findDOMNode(highlighted);
        var relativeOffsetTop = highlightedNode.offsetTop - scrollableNode.scrollTop;
        var scrollTopDelta = 0;
        if (relativeOffsetTop + highlightedNode.offsetHeight > scrollableNode.clientHeight) {
          scrollTopDelta = relativeOffsetTop + highlightedNode.offsetHeight - scrollableNode.clientHeight;
        } else if (relativeOffsetTop < 0) {
          scrollTopDelta = relativeOffsetTop;
        }
        if (scrollTopDelta) {
          this.preventHighlight = true;
          scrollableNode.scrollTop += scrollTopDelta;
          if (this.timeout) clearTimeout(this.timeout);
          this.timeout = setTimeout(function () {
            return _this3.preventHighlight = false;
          }, 100);
        }
      }
    }
  }, {
    key: "mouseMoveHandler",
    value: function mouseMoveHandler(x) {
      // TODO: This is an ugly hack to avoid highlighting the element under the
      // mouse when an arrow key trigger a scroll of the list (which in turn
      // triggers a mousemove event).
      !this.preventHighlight && this.props.onMouseMove(x);
    }
  }, {
    key: "mouseLeaveHandler",
    value: function mouseLeaveHandler() {
      // TODO: clear highlighted?
    }
  }, {
    key: "render",
    value: function render() {
      var _this4 = this;
      var items = this.props.items.map(function (x) {
        var highlighted = x === _this4.props.highlighted;
        var props = {
          highlighted: highlighted,
          label: x.get('label'),
          onClick: function onClick() {
            return _this4.props.onClick(x);
          },
          onMouseMove: function onMouseMove() {
            return _this4.mouseMoveHandler(x);
          }
        };
        if (highlighted) props.ref = 'highlighted';
        return /*#__PURE__*/_react.default.createElement(Item, _extends({
          key: x.get('label')
        }, props));
      });
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "auth0-lock-list-code",
        onMouseLeave: this.mouseLeaveHandler.bind(this)
      }, /*#__PURE__*/_react.default.createElement("ul", null, items));
    }
  }]);
}(_react.default.Component);
var Item = /*#__PURE__*/function (_React$Component3) {
  function Item() {
    _classCallCheck(this, Item);
    return _callSuper(this, Item, arguments);
  }
  _inherits(Item, _React$Component3);
  return _createClass(Item, [{
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps) {
      return this.props.highlighted != nextProps.highlighted;
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
        highlighted = _this$props2.highlighted,
        label = _this$props2.label,
        onClick = _this$props2.onClick,
        onMouseMove = _this$props2.onMouseMove;
      var className = highlighted ? 'auth0-lock-list-code-highlighted' : '';
      return /*#__PURE__*/_react.default.createElement("li", {
        className: className,
        onClick: onClick,
        onMouseMove: onMouseMove
      }, label);
    }
  }]);
}(_react.default.Component);
_defineProperty(Item, "propTypes", {
  highlighted: _propTypes.default.bool.isRequired,
  label: _propTypes.default.string.isRequired,
  onClick: _propTypes.default.func.isRequired,
  onMouseMove: _propTypes.default.func.isRequired
});
