"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _auth_button = _interopRequireDefault(require("../button/auth_button"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
var QuickAuthPane = function QuickAuthPane(props) {
  var alternativeLabel = props.alternativeLabel,
    alternativeClickHandler = props.alternativeClickHandler,
    buttonLabel = props.buttonLabel,
    buttonClickHandler = props.buttonClickHandler,
    header = props.header,
    strategy = props.strategy,
    buttonIcon = props.buttonIcon,
    primaryColor = props.primaryColor,
    foregroundColor = props.foregroundColor;
  var alternative = alternativeLabel ? /*#__PURE__*/_react.default.createElement("p", {
    className: "auth0-lock-alternative"
  }, /*#__PURE__*/_react.default.createElement("a", {
    className: "auth0-lock-alternative-link",
    href: "#",
    onClick: function onClick(e) {
      e.preventDefault();
      alternativeClickHandler(e);
    }
  }, alternativeLabel)) : null;
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "auth0-lock-last-login-pane"
  }, header, /*#__PURE__*/_react.default.createElement(_auth_button.default, {
    label: buttonLabel,
    onClick: function onClick(e) {
      e.preventDefault();
      buttonClickHandler(e);
    },
    strategy: strategy,
    primaryColor: primaryColor,
    foregroundColor: foregroundColor,
    icon: buttonIcon
  }), alternative, /*#__PURE__*/_react.default.createElement("div", {
    className: "auth0-loading-container"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "auth0-loading"
  })));
};
QuickAuthPane.propTypes = {
  alternativeLabel: _propTypes.default.string,
  alternativeClickHandler: function alternativeClickHandler(props, propName, component) {
    if (props.alternativeLabel !== undefined) {
      var _PropTypes$func;
      for (var _len = arguments.length, rest = new Array(_len > 3 ? _len - 3 : 0), _key = 3; _key < _len; _key++) {
        rest[_key - 3] = arguments[_key];
      }
      return (_PropTypes$func = _propTypes.default.func).isRequired.apply(_PropTypes$func, [props, propName, component].concat(rest));
    }
  },
  buttonLabel: _propTypes.default.string.isRequired,
  buttonClickHandler: _propTypes.default.func.isRequired,
  header: _propTypes.default.element,
  strategy: _propTypes.default.string.isRequired
};
var _default = exports.default = QuickAuthPane;
