"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.delay = void 0;
exports.doWhile = doWhile;
exports.getDeferred = getDeferred;
exports.combineParallelCalls = combineParallelCalls;
const delay = (ms, options = {}) => new Promise((resolve) => {
    const timer = setTimeout(resolve, ms);
    if (options.unref && timer.unref) {
        timer.unref();
    }
});
exports.delay = delay;
async function doWhile(doFn, whileFn) {
    do {
        await doFn();
    } while (await whileFn());
}
function getDeferred() {
    let resolve;
    let reject;
    const promise = new Promise((resolveCb, rejectCb) => {
        resolve = resolveCb;
        reject = rejectCb;
    });
    return Object.assign(promise, { resolve, reject, promise });
}
/**
 * Wrap a function, so that any parallel calls which happen while the async function
 * is pending return the same value as the first call (so the function is only run
 * once, but the result is shared). This is useful for expensive async functions or
 * race conditions. This ignores arguments completely, and is only applicable for
 * functions that don't need any other input.
 */
function combineParallelCalls(fn) {
    let pendingPromise;
    return () => {
        if (pendingPromise === undefined) {
            pendingPromise = fn().finally(() => {
                pendingPromise = undefined;
            });
        }
        return pendingPromise;
    };
}
//# sourceMappingURL=promises.js.map