"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.truncateWithEllipsis = truncateWithEllipsis;
exports.joinAnd = joinAnd;
exports.aOrAn = aOrAn;
function truncateWithEllipsis(str, length) {
    if (str.length <= length) {
        return str;
    }
    else {
        return str.slice(0, length - 3) + "...";
    }
}
function joinAnd(val, options = {}) {
    if (val.length === 1)
        return val[0];
    const separator = options.separator ?? ', ';
    const finalSeparator = options.finalSeparator ?? 'and ';
    const oxfordComma = options.oxfordComma ?? false;
    return val.slice(0, -1).join(separator) +
        (oxfordComma ? separator : ' ') +
        finalSeparator +
        val[val.length - 1];
}
const VOWEL_ISH = ['a', 'e', 'i', 'o', 'u', 'y'];
function aOrAn(value) {
    if (VOWEL_ISH.includes(value[0].toLowerCase()))
        return 'an';
    else
        return 'a';
}
//# sourceMappingURL=text.js.map