import { IdentifierNode } from './identifier-node.js';
import type { OperationNode } from './operation-node.js';
export interface CollateNode extends OperationNode {
    readonly kind: 'CollateNode';
    readonly collation: IdentifierNode;
}
type CollateNodeFactory = Readonly<{
    is(node: OperationNode): node is CollateNode;
    create(collation: string): Readonly<CollateNode>;
}>;
/**
 * @internal
 */
export declare const CollateNode: CollateNodeFactory;
export {};
