import type { OperationNode } from './operation-node.js';
import type { OrderByItemNode } from './order-by-item-node.js';
import { OrderByNode } from './order-by-node.js';
import type { PartitionByItemNode } from './partition-by-item-node.js';
import { PartitionByNode } from './partition-by-node.js';
export interface OverNode extends OperationNode {
    readonly kind: 'OverNode';
    readonly orderBy?: OrderByNode;
    readonly partitionBy?: PartitionByNode;
}
type OverNodeFactory = Readonly<{
    is(node: OperationNode): node is OverNode;
    create(): Readonly<OverNode>;
    cloneWithOrderByItems(overNode: OverNode, items: ReadonlyArray<OrderByItemNode>): Readonly<OverNode>;
    cloneWithPartitionByItems(overNode: OverNode, items: ReadonlyArray<PartitionByItemNode>): Readonly<OverNode>;
}>;
/**
 * @internal
 */
export declare const OverNode: OverNodeFactory;
export {};
