/// <reference types="node" />
import { Duplex } from 'stream';
import type { AdminPlugin } from './admin-plugin-types';
import { MockttpOptions, PortRange } from "../mockttp";
import { MockttpServer } from "../server/mockttp-server";
export interface MockttpPluginOptions {
    options?: Partial<MockttpOptions>;
    port?: number | PortRange;
}
export interface MockttpClientResponse {
    port: number;
    mockRoot: string;
}
export declare class MockttpAdminPlugin implements AdminPlugin<MockttpPluginOptions, MockttpClientResponse> {
    private mockServer;
    start({ port, options }: MockttpPluginOptions): Promise<{
        port: number;
        mockRoot: string;
    }>;
    stop(): Promise<void>;
    reset(): void;
    getMockServer(): MockttpServer;
    enableDebug(): void;
    schema: import("graphql").DocumentNode;
    buildResolvers(stream: Duplex, ruleParameters: {
        [key: string]: any;
    }): import("@graphql-tools/utils").IResolvers<any, any, Record<string, any>, any>;
}
//# sourceMappingURL=mockttp-admin-plugin.d.ts.map