"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MockttpAdminPlugin = void 0;
const mockttp_server_1 = require("../server/mockttp-server");
const mockttp_admin_model_1 = require("./mockttp-admin-model");
const mockttp_schema_1 = require("./mockttp-schema");
class MockttpAdminPlugin {
    constructor() {
        this.schema = mockttp_schema_1.MockttpSchema;
    }
    async start({ port, options }) {
        this.mockServer = new mockttp_server_1.MockttpServer(options);
        await this.mockServer.start(port);
        return {
            port: this.mockServer.port,
            mockRoot: this.mockServer.url
        };
    }
    stop() {
        return this.mockServer.stop();
    }
    reset() {
        return this.mockServer.reset();
    }
    getMockServer() {
        return this.mockServer;
    }
    enableDebug() {
        this.mockServer.enableDebug();
    }
    buildResolvers(stream, ruleParameters) {
        return (0, mockttp_admin_model_1.buildAdminServerModel)(this.mockServer, stream, ruleParameters);
    }
    ;
}
exports.MockttpAdminPlugin = MockttpAdminPlugin;
//# sourceMappingURL=mockttp-admin-plugin.js.map