"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MockttpAdminServer = void 0;
const _ = require("lodash");
const admin_server_1 = require("./admin-server");
const mockttp_admin_plugin_1 = require("./mockttp-admin-plugin");
class MockttpAdminServer extends admin_server_1.AdminServer {
    constructor(options) {
        super({
            ..._.omit(options, 'serverDefaults'),
            pluginDefaults: { http: { options: options.serverDefaults } },
            adminPlugins: { http: mockttp_admin_plugin_1.MockttpAdminPlugin }
        });
    }
}
exports.MockttpAdminServer = MockttpAdminServer;
//# sourceMappingURL=mockttp-admin-server.js.map