import { MockedEndpoint } from "../types";
import { Mockttp, AbstractMockttp, MockttpOptions, PortRange, SubscribableEvent } from "../mockttp";
import type { RequestRuleData } from "../rules/requests/request-rule";
import type { WebSocketRuleData } from '../rules/websockets/websocket-rule';
import { AdminClientEvent } from './admin-client';
export interface MockttpClientOptions extends MockttpOptions {
    /**
     * The full URL to use to connect to a Mockttp admin server when using a
     * remote (or local but browser) client.
     *
     * When using a local server, this option is ignored.
     */
    adminServerUrl?: string;
    /**
     * Options to include on all client requests, e.g. to add extra
     * headers for authentication.
     */
    client?: {
        headers?: {
            [key: string]: string;
        };
    };
}
export declare type MockttpClientEvent = `admin-client:${AdminClientEvent}`;
/**
 * A Mockttp implementation, controlling a remote Mockttp admin server.
 *
 * A MockttpClient supports the exact same Mockttp API as MockttpServer, but rather
 * than directly using Node.js APIs to start a mock server and rewrite traffic, it
 * makes calls to a remote admin server to start a mock server and rewrite traffic
 * there. This is useful to allow proxy configuration from inside browser tests, and
 * to allow creating mock proxies that run on remote machines.
 */
export declare class MockttpClient extends AbstractMockttp implements Mockttp {
    private mockServerOptions;
    private adminClient;
    private requestBuilder;
    constructor(options?: MockttpClientOptions);
    enableDebug(): Promise<void>;
    reset: () => Promise<void>;
    get url(): string;
    get port(): number;
    start(port?: number | PortRange): Promise<void>;
    stop(): Promise<void>;
    addRequestRules: (...rules: RequestRuleData[]) => Promise<MockedEndpoint[]>;
    setRequestRules: (...rules: RequestRuleData[]) => Promise<MockedEndpoint[]>;
    addWebSocketRules: (...rules: WebSocketRuleData[]) => Promise<MockedEndpoint[]>;
    setWebSocketRules: (...rules: WebSocketRuleData[]) => Promise<MockedEndpoint[]>;
    private _addRequestRules;
    private _addWsRules;
    getMockedEndpoints(): Promise<MockedEndpoint[]>;
    getPendingEndpoints(): Promise<MockedEndpoint[]>;
    getRuleParameterKeys(): Promise<string[]>;
    on(event: SubscribableEvent | MockttpClientEvent, callback: (data: any) => void): Promise<void>;
}
//# sourceMappingURL=mockttp-client.d.ts.map