import { Mockttp, MockttpOptions } from "./mockttp";
export { Method, RulePriority } from "./types";
import * as matchers from './rules/matchers';
import * as requestHandlerDefinitions from './rules/requests/request-handler-definitions';
import * as webSocketHandlerDefinitions from './rules/websockets/websocket-handler-definitions';
import * as completionCheckers from './rules/completion-checkers';
export { matchers, requestHandlerDefinitions, webSocketHandlerDefinitions, completionCheckers };
export declare const requestHandlers: {
    SimpleHandler: typeof requestHandlerDefinitions.SimpleHandlerDefinition;
    CallbackHandler: typeof requestHandlerDefinitions.CallbackHandlerDefinition;
    StreamHandler: typeof requestHandlerDefinitions.StreamHandlerDefinition;
    FileHandler: typeof requestHandlerDefinitions.FileHandlerDefinition;
    PassThroughHandler: typeof requestHandlerDefinitions.PassThroughHandlerDefinition;
    CloseConnectionHandler: typeof requestHandlerDefinitions.CloseConnectionHandlerDefinition;
    TimeoutHandler: typeof requestHandlerDefinitions.TimeoutHandlerDefinition;
    HandlerLookup: {
        simple: typeof requestHandlerDefinitions.SimpleHandlerDefinition;
        callback: typeof requestHandlerDefinitions.CallbackHandlerDefinition;
        stream: typeof requestHandlerDefinitions.StreamHandlerDefinition;
        file: typeof requestHandlerDefinitions.FileHandlerDefinition;
        passthrough: typeof requestHandlerDefinitions.PassThroughHandlerDefinition;
        'close-connection': typeof requestHandlerDefinitions.CloseConnectionHandlerDefinition;
        'reset-connection': typeof requestHandlerDefinitions.ResetConnectionHandlerDefinition;
        timeout: typeof requestHandlerDefinitions.TimeoutHandlerDefinition;
        'json-rpc-response': typeof requestHandlerDefinitions.JsonRpcResponseHandlerDefinition;
    };
};
export declare const webSocketHandlers: {
    PassThroughWebSocketHandler: typeof webSocketHandlerDefinitions.PassThroughWebSocketHandlerDefinition;
    CloseConnectionHandler: typeof requestHandlerDefinitions.CloseConnectionHandlerDefinition;
    TimeoutHandler: typeof requestHandlerDefinitions.TimeoutHandlerDefinition;
    WsHandlerLookup: {
        'ws-passthrough': typeof webSocketHandlerDefinitions.PassThroughWebSocketHandlerDefinition;
        'ws-echo': typeof webSocketHandlerDefinitions.EchoWebSocketHandlerDefinition;
        'ws-listen': typeof webSocketHandlerDefinitions.ListenWebSocketHandlerDefinition;
        'ws-reject': typeof webSocketHandlerDefinitions.RejectWebSocketHandlerDefinition;
        'close-connection': typeof requestHandlerDefinitions.CloseConnectionHandlerDefinition;
        'reset-connection': typeof requestHandlerDefinitions.ResetConnectionHandlerDefinition;
        timeout: typeof requestHandlerDefinitions.TimeoutHandlerDefinition;
    };
};
export { MOCKTTP_PARAM_REF } from './rules/rule-parameters';
export declare function getLocal(options?: MockttpOptions): Mockttp;
export declare function getRemote(options?: MockttpOptions): Mockttp;
export declare function getAdminServer(): never;
export { resetAdminServer } from "./client/admin-client";
export * as PluggableAdmin from './pluggable-admin-api/pluggable-admin';
export * as MockttpPluggableAdmin from './pluggable-admin-api/mockttp-pluggable-admin';
//# sourceMappingURL=main.browser.d.ts.map