/// <reference types="node" />
import * as _ from 'lodash';
import * as tls from 'tls';
import { Headers } from '../types';
import { DnsLookupFunction } from '../util/dns';
import { CallbackRequestResult, CallbackResponseMessageResult } from './requests/request-handler-definitions';
import { PassThroughLookupOptions } from './passthrough-handling-definitions';
export declare const getUpstreamTlsOptions: (strictChecks: boolean) => tls.SecureContextOptions;
/**
 * Takes a callback result and some headers, and returns a ready to send body, using the headers
 * (and potentially modifying them) to match the content type & encoding.
 */
export declare function buildOverriddenBody(callbackResult: CallbackRequestResult | CallbackResponseMessageResult | void, headers: Headers): Promise<Uint8Array | Buffer | undefined>;
/**
 * Autocorrect the host header only in the case that if you didn't explicitly
 * override it yourself for some reason (e.g. if you're testing bad behaviour).
 */
export declare function getHostAfterModification(reqUrl: string, originalHeaders: Headers, replacementHeaders: Headers | undefined): string;
export declare const OVERRIDABLE_REQUEST_PSEUDOHEADERS: readonly [":authority", ":scheme"];
/**
 * Automatically update the :scheme and :authority headers to match the updated URL,
 * as long as they weren't explicitly overriden themselves, in which case let them
 * be set to any invalid value you like (e.g. to send a request to one server but
 * pretend it was sent to another).
 */
export declare function getH2HeadersAfterModification(reqUrl: string, originalHeaders: Headers, replacementHeaders: Headers | undefined): {
    [K in typeof OVERRIDABLE_REQUEST_PSEUDOHEADERS[number]]: string;
};
export declare function getContentLengthAfterModification(body: string | Uint8Array | Buffer, originalHeaders: Headers, replacementHeaders: Headers | undefined, mismatchAllowed?: boolean): string | undefined;
export declare function shouldUseStrictHttps(hostname: string, port: number, ignoreHostHttpsErrors: string[] | boolean): boolean;
export declare const getDnsLookupFunction: ((lookupOptions: PassThroughLookupOptions | undefined) => DnsLookupFunction) & _.MemoizedFunction;
export declare function getClientRelativeHostname(hostname: string | null, remoteIp: string | undefined, lookupFn: DnsLookupFunction): Promise<string | null>;
//# sourceMappingURL=passthrough-handling.d.ts.map