import { TypedError } from 'typed-error';
import { OngoingRequest, OngoingResponse } from "../../types";
import { ClientServerChannel } from '../../serialization/serialization';
import { RuleParameters } from '../rule-parameters';
import { ForwardingOptions, PassThroughLookupOptions } from '../passthrough-handling-definitions';
import { CallbackHandlerDefinition, CallbackRequestResult, CallbackResponseMessageResult, CallbackResponseResult, CloseConnectionHandlerDefinition, FileHandlerDefinition, HandlerDefinitionLookup, JsonRpcResponseHandlerDefinition, PassThroughHandlerDefinition, PassThroughHandlerOptions, PassThroughResponse, RequestHandlerDefinition, RequestTransform, ResetConnectionHandlerDefinition, ResponseTransform, SerializedCallbackHandlerData, SerializedPassThroughData, SerializedStreamHandlerData, SimpleHandlerDefinition, StreamHandlerDefinition, TimeoutHandlerDefinition } from './request-handler-definitions';
export { CallbackRequestResult, CallbackResponseMessageResult, CallbackResponseResult, ForwardingOptions, PassThroughResponse, PassThroughHandlerOptions, PassThroughLookupOptions, RequestTransform, ResponseTransform };
export declare class AbortError extends TypedError {
    readonly code?: string | undefined;
    constructor(message: string, code?: string | undefined);
}
export interface RequestHandler extends RequestHandlerDefinition {
    handle(request: OngoingRequest, response: OngoingResponse, options: RequestHandlerOptions): Promise<void>;
}
export interface RequestHandlerOptions {
    emitEventCallback?: (type: string, event: unknown) => void;
}
export declare class SimpleHandler extends SimpleHandlerDefinition {
    handle(_request: OngoingRequest, response: OngoingResponse): Promise<void>;
}
export declare class CallbackHandler extends CallbackHandlerDefinition {
    handle(request: OngoingRequest, response: OngoingResponse): Promise<void>;
    /**
     * @internal
     */
    static deserialize({ name, version }: SerializedCallbackHandlerData, channel: ClientServerChannel): CallbackHandler;
}
export declare class StreamHandler extends StreamHandlerDefinition {
    handle(_request: OngoingRequest, response: OngoingResponse): Promise<void>;
    /**
     * @internal
     */
    static deserialize(handlerData: SerializedStreamHandlerData, channel: ClientServerChannel): StreamHandler;
}
export declare class FileHandler extends FileHandlerDefinition {
    handle(_request: OngoingRequest, response: OngoingResponse): Promise<void>;
}
export declare class PassThroughHandler extends PassThroughHandlerDefinition {
    private _trustedCACertificates;
    private trustedCACertificates;
    handle(clientReq: OngoingRequest, clientRes: OngoingResponse, options: RequestHandlerOptions): Promise<void>;
    /**
     * @internal
     */
    static deserialize(data: SerializedPassThroughData, channel: ClientServerChannel, ruleParams: RuleParameters): PassThroughHandler;
}
export declare class CloseConnectionHandler extends CloseConnectionHandlerDefinition {
    handle(request: OngoingRequest): Promise<void>;
}
export declare class ResetConnectionHandler extends ResetConnectionHandlerDefinition {
    constructor();
    handle(request: OngoingRequest): Promise<void>;
    /**
     * @internal
     */
    static deserialize(): ResetConnectionHandler;
}
export declare class TimeoutHandler extends TimeoutHandlerDefinition {
    handle(): Promise<void>;
}
export declare class JsonRpcResponseHandler extends JsonRpcResponseHandlerDefinition {
    handle(request: OngoingRequest, response: OngoingResponse): Promise<void>;
}
export declare const HandlerLookup: typeof HandlerDefinitionLookup;
//# sourceMappingURL=request-handlers.d.ts.map