import { OngoingRequest, CompletedRequest, OngoingResponse, Explainable } from "../../types";
import { MaybePromise } from '../../util/type-utils';
import * as matchers from "../matchers";
import type { RequestHandlerDefinition } from "./request-handler-definitions";
import { RequestHandler } from "./request-handlers";
import * as completionCheckers from "../completion-checkers";
export interface RequestRule extends Explainable {
    id: string;
    requests: Promise<CompletedRequest>[];
    matches(request: OngoingRequest): MaybePromise<boolean>;
    handle(request: OngoingRequest, response: OngoingResponse, options: {
        record: boolean;
        emitEventCallback?: (type: string, event: unknown) => void;
    }): Promise<void>;
    isComplete(): boolean | null;
}
export interface RequestRuleData {
    id?: string;
    priority?: number;
    matchers: matchers.RequestMatcher[];
    handler: RequestHandler | RequestHandlerDefinition;
    completionChecker?: completionCheckers.RuleCompletionChecker;
}
export declare class RequestRule implements RequestRule {
    private matchers;
    private handler;
    private completionChecker?;
    id: string;
    readonly priority: number;
    requests: Promise<CompletedRequest>[];
    requestCount: number;
    constructor(data: RequestRuleData);
    explain(withoutExactCompletion?: boolean): string;
    dispose(): void;
}
//# sourceMappingURL=request-rule.d.ts.map