export declare type RuleParameters = {
    [key: string]: unknown;
};
export declare const MOCKTTP_PARAM_REF: unique symbol;
/**
 * A reference to a rule parameter defined in the `ruleParameters` admin server
 * option of the corresponding admin server.
 *
 * Rule parameter references are only valid with a remote client. They can be useful in
 * cases where the admin server has access to local state or APIs that are not
 * accessible from the remote client, but which would be  useful in rule definitions. This
 * is only supported for some specific parameters where documented explicitly in that rule
 * parameter.
 */
export declare type RuleParameterReference<R> = {
    [MOCKTTP_PARAM_REF]: string;
};
export declare function isParamReference(input: any): input is RuleParameterReference<unknown>;
export declare function dereferenceParam<R>(paramRef: RuleParameterReference<R>, params: RuleParameters): R;
export declare function assertParamDereferenced<R>(maybeParamRef: R | RuleParameterReference<R>): R;
//# sourceMappingURL=rule-parameters.d.ts.map