"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.serializeRuleData = exports.validateMockRuleData = void 0;
const serialization_1 = require("../serialization/serialization");
function validateMockRuleData(data) {
    if (!data.matchers || data.matchers.length === 0) {
        throw new Error('Cannot create a rule without at least one matcher');
    }
    if (!data.handler) {
        throw new Error('Cannot create a rule with no handler');
    }
}
exports.validateMockRuleData = validateMockRuleData;
function serializeRuleData(data, stream) {
    validateMockRuleData(data);
    return {
        id: data.id,
        priority: data.priority,
        matchers: data.matchers.map(m => (0, serialization_1.serialize)(m, stream)),
        handler: (0, serialization_1.serialize)(data.handler, stream),
        completionChecker: data.completionChecker && (0, serialization_1.serialize)(data.completionChecker, stream)
    };
}
exports.serializeRuleData = serializeRuleData;
;
//# sourceMappingURL=rule-serialization.js.map