/// <reference types="node" />
import net = require('net');
import * as http from 'http';
import { ClientServerChannel } from "../../serialization/serialization";
import { OngoingRequest } from "../../types";
import { CloseConnectionHandler, ResetConnectionHandler, TimeoutHandler } from '../requests/request-handlers';
import { RuleParameters } from '../rule-parameters';
import { EchoWebSocketHandlerDefinition, ListenWebSocketHandlerDefinition, PassThroughWebSocketHandlerDefinition, PassThroughWebSocketHandlerOptions, RejectWebSocketHandlerDefinition, SerializedPassThroughWebSocketData, WebSocketHandlerDefinition, WsHandlerDefinitionLookup } from './websocket-handler-definitions';
export interface WebSocketHandler extends WebSocketHandlerDefinition {
    handle(request: OngoingRequest & http.IncomingMessage, socket: net.Socket, head: Buffer): Promise<void>;
}
export { PassThroughWebSocketHandlerOptions };
export declare class PassThroughWebSocketHandler extends PassThroughWebSocketHandlerDefinition {
    private wsServer?;
    private initializeWsServer;
    private _trustedCACertificates;
    private trustedCACertificates;
    handle(req: OngoingRequest, socket: net.Socket, head: Buffer): Promise<void>;
    private connectUpstream;
    /**
     * @internal
     */
    static deserialize(data: SerializedPassThroughWebSocketData, channel: ClientServerChannel, ruleParams: RuleParameters): any;
}
export declare class EchoWebSocketHandler extends EchoWebSocketHandlerDefinition {
    private wsServer?;
    private initializeWsServer;
    handle(req: OngoingRequest & http.IncomingMessage, socket: net.Socket, head: Buffer): Promise<void>;
}
export declare class ListenWebSocketHandler extends ListenWebSocketHandlerDefinition {
    private wsServer?;
    private initializeWsServer;
    handle(req: OngoingRequest & http.IncomingMessage, socket: net.Socket, head: Buffer): Promise<void>;
}
export declare class RejectWebSocketHandler extends RejectWebSocketHandlerDefinition {
    handle(req: OngoingRequest, socket: net.Socket, head: Buffer): Promise<void>;
}
export { CloseConnectionHandler, ResetConnectionHandler, TimeoutHandler };
export declare const WsHandlerLookup: typeof WsHandlerDefinitionLookup;
//# sourceMappingURL=websocket-handlers.d.ts.map