/// <reference types="node" />
import { CompletedBody, Headers } from "../types";
import { Replace } from "../util/type-utils";
export declare function withSerializedBodyReader<T extends {
    body: CompletedBody;
}>(input: T): Replace<T, {
    body: string;
}>;
export declare function withDeserializedBodyReader<T extends {
    headers: Headers;
    body: CompletedBody;
}>(input: Replace<T, {
    body: string;
}>): T;
/**
 * Serialize a callback result (callback handlers, BeforeRequest/Response etc)
 * to transform all the many possible buffer formats into either base64-encoded
 * buffer data, or undefined.
 */
export declare function withSerializedCallbackBuffers<T extends {
    body?: CompletedBody | Buffer | Uint8Array | ArrayBuffer | string;
    rawBody?: Buffer | Uint8Array;
}>(input: T): Replace<T, {
    body: string | undefined;
}>;
export declare type WithSerializedCallbackBuffers<T extends {
    body?: any;
}> = Replace<T, {
    body?: string;
    rawBody?: string;
}>;
/**
 * Deserialize a callback result (callback handlers, BeforeRequest/Response etc)
 * to build buffer data (or undefined) from the base64-serialized data
 * produced by withSerializedCallbackBuffers
 */
export declare function withDeserializedCallbackBuffers<T extends {
    body?: Buffer | Uint8Array | string;
    rawBody?: Buffer | Uint8Array;
}>(input: Replace<T, {
    body?: string;
    rawBody?: string;
}>): T;
//# sourceMappingURL=body-serialization.d.ts.map