/// <reference types="node" />
import net = require('net');
import tls = require('tls');
import http = require('http');
import { DestroyableServer } from 'destroyable-server';
import { TlsHandshakeFailure } from '../types';
import { MockttpHttpsOptions } from '../mockttp';
export declare type ComboServerOptions = {
    debug: boolean;
    https: MockttpHttpsOptions | undefined;
    http2: true | false | 'fallback';
};
export declare function createComboServer(options: ComboServerOptions, requestListener: (req: http.IncomingMessage, res: http.ServerResponse) => void, tlsClientErrorListener: (socket: tls.TLSSocket, req: TlsHandshakeFailure) => void, tlsPassthroughListener: (socket: net.Socket, address: string, port?: number) => void): Promise<DestroyableServer<net.Server>>;
//# sourceMappingURL=http-combo-server.d.ts.map