"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServerMockedEndpoint = void 0;
const util = require("util");
class ServerMockedEndpoint {
    constructor(rule) {
        this.rule = rule;
        this.getSeenRequests.bind(this);
    }
    ;
    get id() {
        return this.rule.id;
    }
    getSeenRequests() {
        // Wait for all completed running requests to have all their details available
        return Promise.all(this.rule.requests);
    }
    async isPending() {
        // We don't actually need to wait for rule.requests to complete, because
        // completion rules right now only check requestCount, and that is always
        // updated synchronously when handling starts.
        const ruleCompletion = this.rule.isComplete();
        if (ruleCompletion !== null) {
            // If the rule has a specific completion value, use it
            return !ruleCompletion;
        }
        else {
            // If not, then it's default "at least one" completion:
            return this.rule.requestCount === 0;
        }
    }
    [util.inspect.custom]() {
        return "Mocked endpoint: " + this.toString();
    }
    toString(withoutExactCompletion = false) {
        return this.rule.explain(withoutExactCompletion);
    }
}
exports.ServerMockedEndpoint = ServerMockedEndpoint;
//# sourceMappingURL=mocked-endpoint.js.map