import { InitiatedRequest, CompletedRequest, CompletedResponse, TlsHandshakeFailure, ClientError, WebSocketMessage, WebSocketClose, TlsPassthroughEvent, RuleEvent } from "../types";
import { Mockttp, AbstractMockttp, MockttpOptions, PortRange } from "../mockttp";
import { RequestRuleData } from "../rules/requests/request-rule";
import { ServerMockedEndpoint } from "./mocked-endpoint";
import { WebSocketRuleData } from "../rules/websockets/websocket-rule";
/**
 * A in-process Mockttp implementation. This starts servers on the local machine in the
 * current process, and exposes methods to directly manage them.
 *
 * This class does not work in browsers, as it expects to be able to start HTTP servers.
 */
export declare class MockttpServer extends AbstractMockttp implements Mockttp {
    private requestRuleSets;
    private webSocketRuleSets;
    private httpsOptions;
    private isHttp2Enabled;
    private maxBodySize;
    private app;
    private server;
    private eventEmitter;
    private readonly initialDebugSetting;
    private readonly defaultWsHandler;
    constructor(options?: MockttpOptions);
    start(portParam?: number | PortRange): Promise<void>;
    stop(): Promise<void>;
    enableDebug(): void;
    reset(): void;
    private get address();
    get url(): string;
    get port(): number;
    private addToRuleSets;
    setRequestRules: (...ruleData: RequestRuleData[]) => Promise<ServerMockedEndpoint[]>;
    addRequestRules: (...ruleData: RequestRuleData[]) => Promise<ServerMockedEndpoint[]>;
    setWebSocketRules: (...ruleData: WebSocketRuleData[]) => Promise<ServerMockedEndpoint[]>;
    addWebSocketRules: (...ruleData: WebSocketRuleData[]) => Promise<ServerMockedEndpoint[]>;
    getMockedEndpoints(): Promise<ServerMockedEndpoint[]>;
    getPendingEndpoints(): Promise<ServerMockedEndpoint[]>;
    getRuleParameterKeys(): Promise<never[]>;
    on(event: 'request-initiated', callback: (req: InitiatedRequest) => void): Promise<void>;
    on(event: 'request', callback: (req: CompletedRequest) => void): Promise<void>;
    on(event: 'response', callback: (req: CompletedResponse) => void): Promise<void>;
    on(event: 'abort', callback: (req: InitiatedRequest) => void): Promise<void>;
    on(event: 'websocket-request', callback: (req: CompletedRequest) => void): Promise<void>;
    on(event: 'websocket-accepted', callback: (req: CompletedResponse) => void): Promise<void>;
    on(event: 'websocket-message-received', callback: (req: WebSocketMessage) => void): Promise<void>;
    on(event: 'websocket-message-sent', callback: (req: WebSocketMessage) => void): Promise<void>;
    on(event: 'websocket-close', callback: (close: WebSocketClose) => void): Promise<void>;
    on(event: 'tls-passthrough-opened', callback: (req: TlsPassthroughEvent) => void): Promise<void>;
    on(event: 'tls-passthrough-closed', callback: (req: TlsPassthroughEvent) => void): Promise<void>;
    on(event: 'tls-client-error', callback: (req: TlsHandshakeFailure) => void): Promise<void>;
    on(event: 'client-error', callback: (error: ClientError) => void): Promise<void>;
    on<T = unknown>(event: 'rule-event', callback: (event: RuleEvent<T>) => void): Promise<void>;
    private announceInitialRequestAsync;
    private announceCompletedRequestAsync;
    private announceResponseAsync;
    private announceWebSocketRequestAsync;
    private announceWebSocketUpgradeAsync;
    private announceWebSocketMessageAsync;
    private announceWebSocketCloseAsync;
    private trackWebSocketEvents;
    private announceAbortAsync;
    private announceTlsErrorAsync;
    private announceClientErrorAsync;
    private announceRuleEventAsync;
    private preprocessRequest;
    private handleRequest;
    private handleWebSocket;
    /**
     * To match rules, we find the first rule (by priority then by set order) which matches and which is
     * either not complete (has a completion check that's false) or which has no completion check defined
     * and is the last option at that priority (i.e. by the last option at each priority repeats indefinitely.
     *
     * We move down the priority list only when either no rules match at all, or when all matching rules
     * have explicit completion checks defined that are completed.
     */
    private findMatchingRule;
    private getUnmatchedRequestExplanation;
    private sendUnmatchedRequestError;
    private sendWebSocketErrorResponse;
    private explainRequest;
    private suggestRule;
    private handleInvalidHttp1Request;
    private handleInvalidHttp2Request;
    private outgoingPassthroughSockets;
    private passthroughSocket;
}
//# sourceMappingURL=mockttp-server.d.ts.map