"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.makePropertyWritable = exports.isNode = exports.isWeb = exports.isWorker = exports.delay = exports.byteLength = exports.nthIndexOf = void 0;
function nthIndexOf(input, matcher, n) {
    let index = -1;
    while (n > 0) {
        n = n - 1;
        index = input.indexOf(matcher, index + 1);
        if (index === -1)
            break;
    }
    return index;
}
exports.nthIndexOf = nthIndexOf;
// Get the length of the given data in bytes, not characters.
// If that's a buffer, the length is used raw, but if it's a string
// it returns the length when encoded as UTF8.
function byteLength(input) {
    if (typeof input === 'string') {
        return exports.isNode
            ? Buffer.from(input, 'utf8').byteLength
            : new Blob([input]).size;
    }
    else {
        return input.length;
    }
}
exports.byteLength = byteLength;
function delay(t) {
    return new Promise((r) => setTimeout(r, t));
}
exports.delay = delay;
exports.isWorker = typeof WorkerGlobalScope !== 'undefined' && self instanceof WorkerGlobalScope;
exports.isWeb = typeof Window !== 'undefined' && self instanceof Window;
exports.isNode = !exports.isWorker && !exports.isWeb && typeof process === 'object' && process.version;
const makePropertyWritable = (obj, property) => Object.defineProperty(obj, property, {
    value: obj[property],
    writable: true
});
exports.makePropertyWritable = makePropertyWritable;
//# sourceMappingURL=util.js.map